/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.atlas;

import java.util.Collection;
import java.util.List;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.InstanceSerialization;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

final class TalendAtlasClient {
    private static final Logger LOG = Logger.getLogger(TalendAtlasClient.class);
    private final AtlasClient client;

    TalendAtlasClient(String url, String login, String password) {
        this.client = new AtlasClient(new String[]{url}, new String[]{login, password});
    }

    private Id persistInstance(Referenceable referenceable) throws Exception {
        String typeName = referenceable.getTypeName();
        String entityJSON = InstanceSerialization.toJson((IStruct)referenceable, (boolean)true);
        System.out.println("Submitting new entity= " + entityJSON);
        List guids = this.client.createEntity(new String[]{entityJSON});
        System.out.println("created instance for type " + typeName + ", guid: " + guids);
        return new Id((String)guids.get(guids.size() - 1), referenceable.getId().getVersion(), referenceable.getTypeName());
    }

    public Id persistInstanceWithLog(Referenceable ref) throws Exception {
        String entityJSON = InstanceSerialization.toJson((IStruct)ref, (boolean)true);
        LOG.debug((Object)("Submitting new entity= " + entityJSON));
        Id idRef = this.persistInstance(ref);
        LOG.debug((Object)("created instance for type " + ref.getTypeName() + ", guid: " + idRef));
        return idRef;
    }

    public List<String> persistTypes(TypesDef typesDef) throws AtlasServiceException {
        String typeAsJson = TypesSerialization.toJson((TypesDef)typesDef);
        return this.client.createType(typeAsJson);
    }

    public Collection<String> getMissingTypes(Collection<String> types) throws AtlasServiceException {
        List allTypes = this.client.listTypes();
        return CollectionUtils.subtract(types, (Collection)allTypes);
    }
}

