/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.cloudera.entity;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MRelation;
import com.cloudera.nav.sdk.model.entities.EndPointProxy;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.relations.RelationRole;
import java.util.ArrayList;
import java.util.List;
import org.talend.lineage.cloudera.entity.TalendEntity;
import org.talend.lineage.cloudera.util.GeneratorID;

@MClass(model="talend")
public class TalendInputEntity
extends TalendEntity {
    private List<String> nextEntitiesId;
    @MRelation(role=RelationRole.TARGET)
    private List<EndPointProxy> targetProxies = new ArrayList<EndPointProxy>();

    public TalendInputEntity(String jobId, String componentName) {
        super(jobId, componentName);
        this.nextEntitiesId = new ArrayList<String>();
    }

    public void addNextEntity(String entityId) {
        this.nextEntitiesId.add(entityId);
        EndPointProxy endpointProxy = new EndPointProxy(entityId, SourceType.SDK, EntityType.OPERATION_EXECUTION);
        this.targetProxies.add(endpointProxy);
    }

    public List<String> getNextEntitiesId() {
        return this.nextEntitiesId;
    }

    public List<EndPointProxy> getTargetProxies() {
        return this.targetProxies;
    }

    public String toString() {
        return this.getName() + " (" + this.getEntityId() + ") --->" + this.nextEntitiesId;
    }

    @Override
    public void connectToEntity(List<String> inputs, List<String> outputs) {
        for (String output : outputs) {
            String id = GeneratorID.generateNodeID(this.getJobId(), output);
            this.addNextEntity(id);
        }
    }
}

