/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.cloudera;

import com.cloudera.nav.sdk.client.NavigatorPlugin;
import com.cloudera.nav.sdk.client.writer.ResultSet;
import com.cloudera.nav.sdk.model.Source;
import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.entities.FileFormat;
import com.cloudera.nav.sdk.model.entities.HdfsEntity;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.talend.lineage.cloudera.EntityMapper;
import org.talend.lineage.cloudera.NavigatorNode;
import org.talend.lineage.cloudera.entity.TalendDataset;
import org.talend.lineage.cloudera.util.ClouderaAPIUtil;
import org.talend.lineage.cloudera.util.ClouderaFieldConvertor;
import org.talend.lineage.common.AbstractLineageCreator;
import org.talend.lineage.common.ILineageCreator;

public class LineageCreator
extends AbstractLineageCreator
implements ILineageCreator {
    public static final String APP_URL = "application_url";
    public static final String FILE_FORMAT = "file_format";
    public static final String METADATA_URI = "metadata_parent_uri";
    public static final String NAMESPACE = "namespace";
    public static final String NAV_URL = "navigator_url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String AUTOCOMMIT = "autocommit";
    public static final String DISABLE_SSL_VALIDATION = "disable_ssl_validation";
    public static final String API_VERSION = "navigator_api_version";
    public static final int DEFAULT_API_VERSION = 8;
    private static Logger LOG = Logger.getLogger(LineageCreator.class);
    private String jobName;
    private String projectName;
    private Source fileSystem;
    private NavigatorPlugin plugin;
    private List<NavigatorNode> inputNavigatorNodes = new ArrayList<NavigatorNode>();
    private List<Entity> datasets = new ArrayList<Entity>();
    private Instant creationInstant;

    public LineageCreator(String clientApplicationUrl, String navigatorUrl, String metadataUri, String username, String password, String jobName, String projectName) {
        this(clientApplicationUrl, navigatorUrl, metadataUri, username, password, jobName, projectName, false);
    }

    public LineageCreator(String clientApplicationUrl, String navigatorUrl, String metadataUri, String username, String password, String jobName, String projectName, Boolean autoCommit) {
        this(clientApplicationUrl, navigatorUrl, metadataUri, username, password, jobName, projectName, autoCommit, false, 8);
    }

    public LineageCreator(String clientApplicationUrl, String navigatorUrl, String metadataUri, String username, String password, String jobName, String projectName, Boolean autoCommit, Boolean disableValidationSSL, int apiVersion) {
        HashMap<String, Object> configurationMap = new HashMap<String, Object>();
        configurationMap.put(APP_URL, clientApplicationUrl);
        configurationMap.put(METADATA_URI, metadataUri);
        configurationMap.put(USERNAME, username);
        configurationMap.put(PASSWORD, password);
        configurationMap.put(FILE_FORMAT, "JSON");
        configurationMap.put(NAMESPACE, "Talend");
        if (disableValidationSSL.booleanValue()) {
            configurationMap.put(DISABLE_SSL_VALIDATION, "true");
        }
        if (autoCommit.booleanValue()) {
            configurationMap.put(AUTOCOMMIT, "true");
        }
        configurationMap.put(API_VERSION, apiVersion);
        configurationMap.put(NAV_URL, ClouderaAPIUtil.extractNavigatorURL(navigatorUrl));
        this.plugin = NavigatorPlugin.fromConfigMap(configurationMap);
        this.fileSystem = this.plugin.getClient().getOnlySource(SourceType.HDFS);
        this.jobName = jobName;
        this.projectName = projectName;
        this.creationInstant = new Instant();
    }

    @Override
    public void addNodeToLineage(String name, Map<String, String> schema, List<String> inputNodes, List<String> outputNodes, Map<String, Object> metadata) {
        if (schema.size() > 0) {
            this.inputNavigatorNodes.add(new NavigatorNode(name, schema, inputNodes, outputNodes));
        }
    }

    @Override
    public void addDataset(Map<String, String> schema, String componentName, String fileSystemPath, String fileFormat) {
        this.addDataset(schema, componentName, fileSystemPath, FileFormat.valueOf((String)fileFormat));
    }

    public void addDataset(Map<String, String> schema, String componentName, String fileSystemPath, FileFormat fileFormat) {
        HdfsEntity container = new HdfsEntity(fileSystemPath, EntityType.DIRECTORY, this.fileSystem.getIdentity());
        TalendDataset dataset = new TalendDataset(ClouderaAPIUtil.getDatasetName(fileSystemPath), componentName, this.jobName + this.projectName);
        dataset.setDataContainer(container);
        dataset.setFileFormat(fileFormat);
        dataset.setFields(ClouderaFieldConvertor.convertToTalendField(schema));
        dataset.addTags((Collection)ImmutableList.of((Object)"Talend", (Object)this.jobName));
        dataset.setCreated(this.creationInstant);
        this.datasets.add((Entity)dataset);
    }

    @Override
    public void sendToLineageProvider(Boolean dieOnError) {
        try {
            ResultSet results = this.plugin.write(this.datasets);
            if (results.hasErrors()) {
                throw new RuntimeException(results.toString());
            }
            EntityMapper tem = new EntityMapper(this.inputNavigatorNodes, this.jobName + this.projectName);
            tem.addTag(this.jobName);
            if (LOG.isDebugEnabled()) {
                for (NavigatorNode nn : this.inputNavigatorNodes) {
                    LOG.debug((Object)nn);
                }
            }
            List<Entity> entities = tem.map();
            LOG.debug((Object)tem.toString());
            results = this.plugin.write(entities);
            if (results.hasErrors()) {
                throw new RuntimeException(results.toString());
            }
        }
        catch (RuntimeException e) {
            if (dieOnError.booleanValue()) {
                throw e;
            }
            LOG.error((Object)e);
        }
    }
}

