/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IObjectCache;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCache;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;

public class XMLObjectCache
implements IObjectCache {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$xml$XMLObjectCache == null ? (class$net$sourceforge$squirrel_sql$fw$xml$XMLObjectCache = XMLObjectCache.class$("net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache")) : class$net$sourceforge$squirrel_sql$fw$xml$XMLObjectCache);
    private ObjectCache _cache = new ObjectCache();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$xml$XMLObjectCache;

    public IHasIdentifier get(Class objClass, IIdentifier id) {
        return this._cache.get(objClass, id);
    }

    public void add(IHasIdentifier obj) throws DuplicateObjectException {
        this._cache.add(obj);
    }

    public void remove(Class objClass, IIdentifier id) {
        this._cache.remove(objClass, id);
    }

    public Class[] getAllClasses() {
        return this._cache.getAllClasses();
    }

    public Iterator getAllForClass(Class objClass) {
        return this._cache.getAllForClass(objClass);
    }

    public void addChangesListener(IObjectCacheChangeListener lis, Class objClass) {
        this._cache.addChangesListener(lis, objClass);
    }

    public void removeChangesListener(IObjectCacheChangeListener lis, Class objClass) {
        this._cache.removeChangesListener(lis, objClass);
    }

    public void load(String xmlFileName) throws FileNotFoundException, XMLException, DuplicateObjectException {
        this.load(xmlFileName, null);
    }

    public void load(String xmlFileName, ClassLoader cl) throws FileNotFoundException, XMLException, DuplicateObjectException {
        XMLBeanReader rdr = new XMLBeanReader();
        rdr.load(xmlFileName, cl);
        Iterator it = rdr.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IHasIdentifier)) {
                throw new XMLException(s_stringMgr.getString("XMLObjectCache.error.notimplemented"));
            }
            this.add((IHasIdentifier)obj);
        }
    }

    public void load(Reader rdr) throws XMLException, DuplicateObjectException {
        this.load(rdr, null, false);
    }

    public void load(Reader rdr, ClassLoader cl, boolean ignoreDuplicates) throws XMLException, DuplicateObjectException {
        XMLBeanReader xmlRdr = new XMLBeanReader();
        xmlRdr.load(rdr, cl);
        Iterator it = xmlRdr.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IHasIdentifier)) {
                throw new XMLException(s_stringMgr.getString("XMLObjectCache.error.notimplemented"));
            }
            try {
                this.add((IHasIdentifier)obj);
            }
            catch (DuplicateObjectException ex) {
                if (ignoreDuplicates) continue;
                throw ex;
            }
        }
    }

    public synchronized void save(String xmlFilename) throws IOException, XMLException {
        XMLBeanWriter wtr = new XMLBeanWriter();
        Class[] classes = this._cache.getAllClasses();
        for (int i = 0; i < classes.length; ++i) {
            Iterator it = this._cache.getAllForClass(classes[i]);
            while (it.hasNext()) {
                wtr.addToRoot(it.next());
            }
        }
        wtr.save(xmlFilename);
    }

    public synchronized void saveAllForClass(String xmlFilename, Class objClass) throws IOException, XMLException {
        XMLBeanWriter wtr = new XMLBeanWriter();
        Iterator it = this._cache.getAllForClass(objClass);
        while (it.hasNext()) {
            wtr.addToRoot(it.next());
        }
        wtr.save(xmlFilename);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

