/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.StringWrapper;

public class SQLDriver
implements ISQLDriver,
Cloneable,
Serializable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver = SQLDriver.class$("net.sourceforge.squirrel_sql.fw.sql.SQLDriver")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver);
    private IIdentifier _id;
    private String _name;
    private String _jarFileName = null;
    private List _jarFileNamesList = new ArrayList();
    private String _driverClassName;
    private String _url;
    private boolean _jdbcDriverClassLoaded;
    private transient PropertyChangeReporter _propChgReporter;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver;

    public SQLDriver(IIdentifier id) {
        this._id = id;
        this._name = "";
        this._jarFileName = null;
        this._driverClassName = null;
        this._url = "";
    }

    public SQLDriver() {
    }

    public synchronized void assignFrom(ISQLDriver rhs) throws ValidationException {
        this.setName(rhs.getName());
        this.setJarFileNames(rhs.getJarFileNames());
        this.setDriverClassName(rhs.getDriverClassName());
        this.setUrl(rhs.getUrl());
        this.setJDBCDriverClassLoaded(rhs.isJDBCDriverClassLoaded());
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((Object)((ISQLDriver)rhs).getIdentifier()).equals(this.getIdentifier());
        }
        return rc;
    }

    public synchronized int hashCode() {
        return ((Object)this.getIdentifier()).hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() {
        try {
            SQLDriver driver = (SQLDriver)super.clone();
            driver._propChgReporter = null;
            return driver;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public int compareTo(Object rhs) {
        return this._name.compareTo(((ISQLDriver)rhs).getName());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    public void setReportPropertyChanges(boolean report) {
        this.getPropertyChangeReporter().setNotify(report);
    }

    public IIdentifier getIdentifier() {
        return this._id;
    }

    public void setIdentifier(IIdentifier id) {
        this._id = id;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public void setDriverClassName(String driverClassName) throws ValidationException {
        String data = this.getString(driverClassName);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_DRIVER);
        }
        if (this._driverClassName != data) {
            String oldValue = this._driverClassName;
            this._driverClassName = data;
            this.getPropertyChangeReporter().firePropertyChange("driverClassName", oldValue, this._driverClassName);
        }
    }

    public String getJarFileName() {
        return this._jarFileName;
    }

    public void setJarFileName(String value) {
        if (value == null) {
            value = "";
        }
        if (this._jarFileName == null || !this._jarFileName.equals(value)) {
            String oldValue = this._jarFileName;
            this._jarFileName = value;
            this.getPropertyChangeReporter().firePropertyChange("jarFileName", oldValue, this._jarFileName);
        }
    }

    public synchronized String[] getJarFileNames() {
        return this._jarFileNamesList.toArray(new String[this._jarFileNamesList.size()]);
    }

    public synchronized void setJarFileNames(String[] values) {
        String[] oldValue = this._jarFileNamesList.toArray(new String[this._jarFileNamesList.size()]);
        this._jarFileNamesList.clear();
        if (values == null) {
            values = new String[]{};
        }
        for (int i = 0; i < values.length; ++i) {
            this._jarFileNamesList.add(values[i]);
        }
        this.getPropertyChangeReporter().firePropertyChange("jarFileNames", oldValue, values);
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) throws ValidationException {
        String data = this.getString(url);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_URL);
        }
        if (this._url != data) {
            String oldValue = this._url;
            this._url = data;
            this.getPropertyChangeReporter().firePropertyChange("url", oldValue, this._url);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) throws ValidationException {
        String data = this.getString(name);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_NAME);
        }
        if (this._name != data) {
            String oldValue = this._name;
            this._name = data;
            this.getPropertyChangeReporter().firePropertyChange("name", oldValue, this._name);
        }
    }

    public boolean isJDBCDriverClassLoaded() {
        return this._jdbcDriverClassLoaded;
    }

    public void setJDBCDriverClassLoaded(boolean cl) {
        this._jdbcDriverClassLoaded = cl;
    }

    public synchronized StringWrapper[] getJarFileNameWrappers() {
        StringWrapper[] wrappers = new StringWrapper[this._jarFileNamesList.size()];
        for (int i = 0; i < wrappers.length; ++i) {
            wrappers[i] = new StringWrapper((String)this._jarFileNamesList.get(i));
        }
        return wrappers;
    }

    public StringWrapper getJarFileNameWrapper(int idx) throws ArrayIndexOutOfBoundsException {
        return new StringWrapper((String)this._jarFileNamesList.get(idx));
    }

    public void setJarFileNameWrappers(StringWrapper[] value) {
        this._jarFileNamesList.clear();
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                this._jarFileNamesList.add(value[i].getString());
            }
        }
    }

    public void setJarFileNameWrapper(int idx, StringWrapper value) throws ArrayIndexOutOfBoundsException {
        this._jarFileNamesList.set(idx, value);
    }

    private String getString(String data) {
        return data != null ? data.trim() : "";
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter(this);
        }
        return this._propChgReporter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface IStrings {
        public static final String ERR_BLANK_NAME = SQLDriver.access$000().getString("SQLDriver.error.blankname");
        public static final String ERR_BLANK_DRIVER = SQLDriver.access$000().getString("SQLDriver.error.blankdriver");
        public static final String ERR_BLANK_URL = SQLDriver.access$000().getString("SQLDriver.error.blankurl");
    }
}

