/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLConnectionState {
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$sql$SQLConnectionState == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLConnectionState = SQLConnectionState.class$("net.sourceforge.squirrel_sql.fw.sql.SQLConnectionState")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLConnectionState);
    private Integer _transIsolation;
    private String _catalog;
    private boolean _autoCommit;
    private SQLDriverPropertyCollection _connProps;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$SQLConnectionState;

    public void saveState(SQLConnection conn) throws SQLException {
        this.saveState(conn, null);
    }

    public void saveState(SQLConnection conn, IMessageHandler msgHandler) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        try {
            this._transIsolation = new Integer(conn.getTransactionIsolation());
        }
        catch (SQLException ex) {
            s_log.error("Error saving transaction isolation", ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(ex);
        }
        try {
            this._catalog = conn.getCatalog();
        }
        catch (SQLException ex) {
            s_log.error("Error saving current catalog", ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(ex);
        }
        try {
            this._autoCommit = conn.getAutoCommit();
        }
        catch (SQLException ex) {
            s_log.error("Error saving autocommit state", ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(ex);
        }
        this._connProps = conn.getConnectionProperties();
    }

    public void restoreState(SQLConnection conn) throws SQLException {
        this.restoreState(conn, null);
    }

    public void restoreState(SQLConnection conn, IMessageHandler msgHandler) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        if (this._transIsolation != null) {
            try {
                conn.setTransactionIsolation(this._transIsolation);
            }
            catch (SQLException ex) {
                s_log.error("Error restoring transaction isolation", ex);
                if (msgHandler == null) {
                    throw ex;
                }
                msgHandler.showErrorMessage(ex);
            }
        }
        if (this._catalog != null) {
            try {
                conn.setCatalog(this._catalog);
            }
            catch (SQLException ex) {
                s_log.error("Error restoring current catalog", ex);
                if (msgHandler == null) {
                    throw ex;
                }
                msgHandler.showErrorMessage(ex);
            }
        }
        try {
            conn.setAutoCommit(this._autoCommit);
        }
        catch (SQLException ex) {
            s_log.error("Error restoring autocommit", ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(ex);
        }
    }

    public SQLDriverPropertyCollection getConnectionProperties() {
        return this._connProps;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

