/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetReader {
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$sql$ResultSetReader == null ? (class$net$sourceforge$squirrel_sql$fw$sql$ResultSetReader = ResultSetReader.class$("net.sourceforge.squirrel_sql.fw.sql.ResultSetReader")) : class$net$sourceforge$squirrel_sql$fw$sql$ResultSetReader);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$sql$ResultSetReader == null ? (class$net$sourceforge$squirrel_sql$fw$sql$ResultSetReader = ResultSetReader.class$("net.sourceforge.squirrel_sql.fw.sql.ResultSetReader")) : class$net$sourceforge$squirrel_sql$fw$sql$ResultSetReader);
    private final ResultSet _rs;
    private final int[] _columnIndices;
    private int _columnCount;
    private boolean _errorOccured = false;
    private ResultSetMetaData _rsmd;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$ResultSetReader;

    public ResultSetReader(ResultSet rs) throws SQLException {
        this(rs, null);
    }

    public ResultSetReader(ResultSet rs, int[] columnIndices) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("ResultSet == null");
        }
        this._rs = rs;
        if (columnIndices != null && columnIndices.length == 0) {
            columnIndices = null;
        }
        this._columnIndices = columnIndices;
        this._rsmd = rs.getMetaData();
        this._columnCount = columnIndices != null ? columnIndices.length : this._rsmd.getColumnCount();
    }

    public Object[] readRow() throws SQLException {
        this._errorOccured = false;
        if (this._rs.next()) {
            return this.doRead();
        }
        return null;
    }

    public Object[] readRow(ColumnDisplayDefinition[] colDefs) throws SQLException {
        this._errorOccured = false;
        if (this._rs.next()) {
            return this.doContentTabRead(colDefs);
        }
        return null;
    }

    public boolean getColumnErrorInPreviousRow() {
        return this._errorOccured;
    }

    private Object[] doRead() {
        Object[] row = new Object[this._columnCount];
        block18: for (int i = 0; i < this._columnCount; ++i) {
            int idx = this._columnIndices != null ? this._columnIndices[i] : i + 1;
            try {
                int columnType = this._rsmd.getColumnType(idx);
                switch (columnType) {
                    case 0: {
                        row[i] = null;
                        break;
                    }
                    case -7: 
                    case 16: {
                        row[i] = this._rs.getObject(idx);
                        if (row[i] == null || row[i] instanceof Boolean) continue block18;
                        if (row[i] instanceof Number) {
                            if (((Number)row[i]).intValue() == 0) {
                                row[i] = Boolean.FALSE;
                                break;
                            }
                            row[i] = Boolean.TRUE;
                            break;
                        }
                        row[i] = Boolean.valueOf(row[i].toString());
                        break;
                    }
                    case 92: {
                        row[i] = this._rs.getTime(idx);
                        break;
                    }
                    case 91: {
                        row[i] = this._rs.getObject(idx);
                        break;
                    }
                    case 93: {
                        row[i] = this._rs.getTimestamp(idx);
                        break;
                    }
                    case -5: {
                        row[i] = this._rs.getObject(idx);
                        if (row[i] == null || row[i] instanceof Long) continue block18;
                        if (row[i] instanceof Number) {
                            row[i] = new Long(((Number)row[i]).longValue());
                            break;
                        }
                        row[i] = new Long(row[i].toString());
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        Number nbr;
                        row[i] = this._rs.getObject(idx);
                        if (row[i] == null || row[i] instanceof Double) continue block18;
                        if (row[i] instanceof Number) {
                            nbr = (Number)row[i];
                            row[i] = new Double(nbr.doubleValue());
                            break;
                        }
                        row[i] = new Double(row[i].toString());
                        break;
                    }
                    case 2: 
                    case 3: {
                        Number nbr;
                        row[i] = this._rs.getObject(idx);
                        if (row[i] == null || row[i] instanceof BigDecimal) continue block18;
                        if (row[i] instanceof Number) {
                            nbr = (Number)row[i];
                            row[i] = new BigDecimal(nbr.doubleValue());
                            break;
                        }
                        row[i] = new BigDecimal(row[i].toString());
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        row[i] = this._rs.getObject(idx);
                        if (this._rs.wasNull()) {
                            row[i] = null;
                        }
                        if (row[i] == null || row[i] instanceof Integer) continue block18;
                        if (row[i] instanceof Number) {
                            row[i] = new Integer(((Number)row[i]).intValue());
                            break;
                        }
                        row[i] = new Integer(row[i].toString());
                        break;
                    }
                    case -9: 
                    case -8: 
                    case -1: 
                    case 1: 
                    case 12: {
                        row[i] = this._rs.getString(idx);
                        if (!this._rs.wasNull()) continue block18;
                        row[i] = null;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        row[i] = this._rs.getString(idx);
                        break;
                    }
                    case 2004: {
                        row[i] = null;
                        Blob blob = this._rs.getBlob(idx);
                        if (blob == null) continue block18;
                        row[i] = s_stringMgr.getString("ResultSetReader.blob");
                        break;
                    }
                    case 2005: {
                        int len;
                        row[i] = null;
                        Clob clob = this._rs.getClob(idx);
                        if (clob == null || (len = (int)clob.length()) <= 0) continue block18;
                        int charsToRead = len;
                        row[i] = clob.getSubString(1L, charsToRead);
                        break;
                    }
                    case 1111: {
                        row[i] = s_stringMgr.getString("ResultSetReader.other");
                        break;
                    }
                    default: {
                        row[i] = s_stringMgr.getString("ResultSetReader.unknown", new Object[]{new Integer(columnType)});
                    }
                }
                continue;
            }
            catch (Throwable th) {
                this._errorOccured = true;
                row[i] = "<Error>";
                StringBuffer msg = new StringBuffer("Error reading column data");
                msg.append(", column index = ").append(idx);
                s_log.error(msg.toString(), th);
            }
        }
        return row;
    }

    private Object[] doContentTabRead(ColumnDisplayDefinition[] colDefs) {
        Object[] row = new Object[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            int idx = this._columnIndices != null ? this._columnIndices[i] : i + 1;
            try {
                int columnType = this._rsmd.getColumnType(idx);
                switch (columnType) {
                    case 0: {
                        row[i] = null;
                        break;
                    }
                    default: {
                        row[i] = CellComponentFactory.readResultSet(colDefs[i], this._rs, idx, true);
                        break;
                    }
                }
                continue;
            }
            catch (Throwable th) {
                this._errorOccured = true;
                row[i] = "<Error>";
                StringBuffer msg = new StringBuffer("Error reading column data");
                msg.append(", column index = ").append(idx);
                s_log.error(msg.toString(), th);
            }
        }
        return row;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

