/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class TableCopyHtmlCommand
implements ICommand {
    private JTable _table;

    public TableCopyHtmlCommand(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Null JTable passed");
        }
        this._table = table;
    }

    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        if (selRows.length != 0 && selCols.length != 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("<table border=1><tr BGCOLOR=\"#CCCCFF\">");
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                buf.append("<th>");
                buf.append(this._table.getColumnName(selCols[colIdx]));
                buf.append("</th>");
            }
            buf.append("</tr>\n");
            for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
                buf.append("<tr>");
                for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                    Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    buf.append("<td>");
                    if (cellObj == null) {
                        buf.append("&nbsp;");
                    } else if (cellObj instanceof String) {
                        String tmp = (String)cellObj;
                        if (tmp.trim().equals("")) {
                            buf.append("&nbsp;");
                        } else {
                            block9: for (int i = 0; i < tmp.length(); ++i) {
                                switch (tmp.charAt(i)) {
                                    case '<': {
                                        buf.append("&lt;");
                                        continue block9;
                                    }
                                    case '>': {
                                        buf.append("&gt;");
                                        continue block9;
                                    }
                                    case '&': {
                                        buf.append("&amp;");
                                        continue block9;
                                    }
                                    case '\"': {
                                        buf.append("&quot;");
                                        continue block9;
                                    }
                                    default: {
                                        buf.append(tmp.charAt(i));
                                    }
                                }
                            }
                        }
                    } else {
                        buf.append(cellObj);
                    }
                    buf.append("</td>");
                }
                buf.append("</tr>\n");
            }
            buf.append("</table>");
            StringSelection ss = new StringSelection(buf.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }
}

