/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StatusBar
extends JPanel {
    private String _msgWhenEmpty = " ";
    private final JLabel _textLbl = new JLabel();
    private final GridBagConstraints _gbc = new GridBagConstraints();
    private Font _font;

    public StatusBar() {
        super(new GridBagLayout());
        this.createGUI();
    }

    public synchronized void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Font == null");
        }
        super.setFont(font);
        this._font = font;
        this.updateSubcomponentsFont(this);
    }

    public synchronized void setText(String text) {
        String myText = null;
        if (text != null) {
            myText = text.trim();
        }
        if (myText != null && myText.length() > 0) {
            this._textLbl.setText(myText);
        } else {
            this.clearText();
        }
    }

    public synchronized void clearText() {
        this._textLbl.setText(this._msgWhenEmpty);
    }

    public synchronized void setTextWhenEmpty(String value) {
        boolean wasEmpty = this._textLbl.getText().equals(this._msgWhenEmpty);
        this._msgWhenEmpty = value != null && value.length() > 0 ? value : " ";
        if (wasEmpty) {
            this.clearText();
        }
    }

    public synchronized void addJComponent(JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("JComponent == null");
        }
        comp.setBorder(StatusBar.createComponentBorder());
        if (this._font != null) {
            comp.setFont(this._font);
            this.updateSubcomponentsFont(comp);
        }
        super.add((Component)comp, this._gbc);
    }

    public static Border createComponentBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(0, 4, 0, 4));
    }

    private void createGUI() {
        this.clearText();
        this._gbc.anchor = 17;
        this._gbc.weightx = 1.0;
        this._gbc.fill = 2;
        this._gbc.gridy = 0;
        this._gbc.gridx = 0;
        this.addJComponent(this._textLbl);
        this._gbc.weightx = 0.0;
        this._gbc.anchor = 10;
        this._gbc.gridx = -1;
    }

    private void updateSubcomponentsFont(Container cont) {
        Component[] comps = cont.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setFont(this._font);
            if (!(comps[i] instanceof Container)) continue;
            this.updateSubcomponentsFont((Container)comps[i]);
        }
    }

    public static class StatusBarLabel
    extends JLabel {
    }
}

