/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class GUIUtils {
    public static void centerWithinParent(Window wind) {
        if (wind == null) {
            throw new IllegalArgumentException("null Window passed");
        }
        Container parent = wind.getParent();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(wind, new Rectangle(parent.getLocationOnScreen(), parent.getSize()));
        } else {
            GUIUtils.centerWithinScreen(wind);
        }
    }

    public static void centerWithinDesktop(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        JDesktopPane parent = frame.getDesktopPane();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(frame, new Rectangle(new Point(0, 0), parent.getSize()));
        }
    }

    public static void centerWithinScreen(Window wind) {
        if (wind == null) {
            throw new IllegalArgumentException("null Window passed");
        }
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        Rectangle rcScreen = new Rectangle(toolKit.getScreenSize());
        Dimension windSize = wind.getSize();
        Dimension parentSize = new Dimension(rcScreen.width, rcScreen.height);
        if (windSize.height > parentSize.height) {
            windSize.height = parentSize.height;
        }
        if (windSize.width > parentSize.width) {
            windSize.width = parentSize.width;
        }
        GUIUtils.center(wind, rcScreen);
    }

    public static Frame getOwningFrame(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("null Component passed");
        }
        if (comp instanceof Frame) {
            return (Frame)comp;
        }
        return GUIUtils.getOwningFrame(SwingUtilities.windowForComponent(comp));
    }

    public static boolean isToolWindow(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        Object obj = frame.getClientProperty("JInternalFrame.isPalette");
        return obj != null && obj == Boolean.TRUE;
    }

    public static void makeToolWindow(JInternalFrame frame, boolean isToolWindow) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        frame.putClientProperty("JInternalFrame.isPalette", isToolWindow ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void setJButtonSizesTheSame(JButton[] btns) {
        if (btns == null) {
            throw new IllegalArgumentException("null JButton[] passed");
        }
        Dimension maxSize = new Dimension(0, 0);
        for (int i = 0; i < btns.length; ++i) {
            JButton btn = btns[i];
            FontMetrics fm = btn.getFontMetrics(btn.getFont());
            Rectangle2D bounds = fm.getStringBounds(btn.getText(), btn.getGraphics());
            int boundsHeight = (int)bounds.getHeight();
            int boundsWidth = (int)bounds.getWidth();
            maxSize.width = boundsWidth > maxSize.width ? boundsWidth : maxSize.width;
            maxSize.height = boundsHeight > maxSize.height ? boundsHeight : maxSize.height;
        }
        Insets insets = btns[0].getInsets();
        maxSize.width += insets.left + insets.right;
        maxSize.height += insets.top + insets.bottom;
        for (int i = 0; i < btns.length; ++i) {
            JButton btn = btns[i];
            btn.setPreferredSize(maxSize);
        }
    }

    public static JInternalFrame[] getOpenToolWindows(JInternalFrame[] frames) {
        if (frames == null) {
            throw new IllegalArgumentException("null JInternalFrame[] passed");
        }
        ArrayList<JInternalFrame> framesList = new ArrayList<JInternalFrame>();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame fr = frames[i];
            if (!GUIUtils.isToolWindow(fr) || fr.isClosed()) continue;
            framesList.add(frames[i]);
        }
        return framesList.toArray(new JInternalFrame[framesList.size()]);
    }

    public static JInternalFrame[] getOpenNonToolWindows(JInternalFrame[] frames) {
        if (frames == null) {
            throw new IllegalArgumentException("null JInternalFrame[] passed");
        }
        ArrayList<JInternalFrame> framesList = new ArrayList<JInternalFrame>();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame fr = frames[i];
            if (GUIUtils.isToolWindow(fr) || fr.isClosed()) continue;
            framesList.add(frames[i]);
        }
        return framesList.toArray(new JInternalFrame[framesList.size()]);
    }

    public static JInternalFrame[] getNonMinimizedNonToolWindows(JInternalFrame[] frames) {
        if (frames == null) {
            throw new IllegalArgumentException("null JInternalFrame[] passed");
        }
        ArrayList<JInternalFrame> framesList = new ArrayList<JInternalFrame>();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame fr = frames[i];
            if (GUIUtils.isToolWindow(fr) || fr.isClosed() || fr.isIcon()) continue;
            framesList.add(frames[i]);
        }
        return framesList.toArray(new JInternalFrame[framesList.size()]);
    }

    public static boolean isWithinParent(Component wind) {
        if (wind == null) {
            throw new IllegalArgumentException("Null Component passed");
        }
        Container parent = wind.getParent();
        Rectangle parentRect = null;
        parentRect = parent != null ? new Rectangle(parent.getSize()) : new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle windowBounds = wind.getBounds();
        return windowBounds.x <= parentRect.width - 20 && windowBounds.y <= parentRect.height - 20 && windowBounds.x + windowBounds.width >= 20 && windowBounds.y + windowBounds.height >= 20;
    }

    private static void center(Component wind, Rectangle rect) {
        if (wind == null || rect == null) {
            throw new IllegalArgumentException("null Window or Rectangle passed");
        }
        Dimension windSize = wind.getSize();
        int x = (rect.width - windSize.width) / 2 + rect.x;
        int y = (rect.height - windSize.height) / 2 + rect.y;
        if (y < rect.y) {
            y = rect.y;
        }
        wind.setLocation(x, y);
    }
}

