/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;

public class DataTypeTimestamp
implements IDataTypeComponent {
    private ColumnDisplayDefinition _colDef;
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp";
    private static int DEFAULT_LOCALE_FORMAT = 3;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean useJavaDefaultFormat = true;
    private static int localeFormat = DEFAULT_LOCALE_FORMAT;
    private static boolean lenient = true;
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(localeFormat, localeFormat);

    public DataTypeTimestamp(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeTimestamp.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            useJavaDefaultFormat = true;
            String useJavaDefaultFormatString = DTProperties.get(thisClassName, "useJavaDefaultFormat");
            if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("false")) {
                useJavaDefaultFormat = false;
            }
            localeFormat = 3;
            String localeFormatString = DTProperties.get(thisClassName, "localeFormat");
            if (localeFormatString != null) {
                localeFormat = Integer.parseInt(localeFormatString);
            }
            lenient = true;
            String lenientString = DTProperties.get(thisClassName, "lenient");
            if (lenientString != null && lenientString.equals("false")) {
                lenient = false;
            }
        }
    }

    public String getClassName() {
        return "java.sql.Timestamp";
    }

    public boolean areEqual(Object obj1, Object obj2) {
        return ((Timestamp)obj1).equals(obj2);
    }

    public String renderObject(Object value) {
        if (useJavaDefaultFormat) {
            return (String)this._renderer.renderObject(value);
        }
        return (String)this._renderer.renderObject(dateFormat.format(value));
    }

    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeTimestamp.this._textComponent, evt, DataTypeTimestamp.this._table);
                    CellDataPopup.showDialog(DataTypeTimestamp.this._table, DataTypeTimestamp.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            if (useJavaDefaultFormat) {
                Timestamp obj = Timestamp.valueOf(value);
                return obj;
            }
            Date javaDate = dateFormat.parse(value);
            return new Timestamp(javaDate.getTime());
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        Timestamp data = rs.getTimestamp(index);
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    public String getWhereClauseValue(Object value) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return this._colDef.getLabel() + " IS NULL";
        }
        return this._colDef.getLabel() + "='" + value.toString() + "'";
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setTimestamp(position, (Timestamp)value);
        }
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Timestamp(new Date().getTime());
    }

    public boolean canDoFileIO() {
        return true;
    }

    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeTimestamp.loadProperties();
        return new BlobOkJPanel();
    }

    private static class BlobOkJPanel
    extends OkJPanel {
        private JCheckBox useJavaDefaultFormatChk = new JCheckBox("Use default format (" + new Timestamp(new Date().getTime()).toString() + ")");
        private RightLabel dateFormatTypeDropLabel = new RightLabel(" or locale-dependent format:");
        private DateFormatTypeCombo dateFormatTypeDrop = new DateFormatTypeCombo();
        private JCheckBox lenientChk = new JCheckBox("allow inexact format on input");

        public BlobOkJPanel() {
            this.useJavaDefaultFormatChk.setSelected(useJavaDefaultFormat);
            this.useJavaDefaultFormatChk.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ BlobOkJPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void stateChanged(ChangeEvent e) {
                    BlobOkJPanel.access$700(this.this$0).setEnabled(!BlobOkJPanel.access$600(this.this$0).isSelected());
                    BlobOkJPanel.access$800(this.this$0).setEnabled(!BlobOkJPanel.access$600(this.this$0).isSelected());
                    BlobOkJPanel.access$900(this.this$0).setEnabled(!BlobOkJPanel.access$600(this.this$0).isSelected());
                }
            });
            this.dateFormatTypeDrop = new DateFormatTypeCombo();
            this.dateFormatTypeDrop.setSelectedIndex(localeFormat);
            this.lenientChk.setSelected(lenient);
            this.dateFormatTypeDrop.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.dateFormatTypeDropLabel.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.lenientChk.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder("Timestamp   (SQL type 93)"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            this.add((Component)this.useJavaDefaultFormatChk, gbc);
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.dateFormatTypeDropLabel, gbc);
            ++gbc.gridx;
            this.add((Component)this.dateFormatTypeDrop, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.lenientChk, gbc);
        }

        public void ok() {
            useJavaDefaultFormat = this.useJavaDefaultFormatChk.isSelected();
            DTProperties.put(DataTypeTimestamp.thisClassName, "useJavaDefaultFormat", Boolean.toString(useJavaDefaultFormat));
            localeFormat = this.dateFormatTypeDrop.getValue();
            dateFormat = DateFormat.getDateTimeInstance(localeFormat, localeFormat);
            DTProperties.put(DataTypeTimestamp.thisClassName, "localeFormat", Integer.toString(localeFormat));
            lenient = this.lenientChk.isSelected();
            dateFormat.setLenient(lenient);
            DTProperties.put(DataTypeTimestamp.thisClassName, "lenient", Boolean.toString(lenient));
        }

        static /* synthetic */ JCheckBox access$600(BlobOkJPanel x0) {
            return x0.useJavaDefaultFormatChk;
        }

        static /* synthetic */ DateFormatTypeCombo access$700(BlobOkJPanel x0) {
            return x0.dateFormatTypeDrop;
        }

        static /* synthetic */ RightLabel access$800(BlobOkJPanel x0) {
            return x0.dateFormatTypeDropLabel;
        }

        static /* synthetic */ JCheckBox access$900(BlobOkJPanel x0) {
            return x0.lenientChk;
        }
    }

    public static class DateFormatTypeCombo
    extends JComboBox {
        public DateFormatTypeCombo() {
            this.addItem("Full (" + DateFormat.getDateTimeInstance(0, 0).format(new Date()) + ")");
            this.addItem("Long (" + DateFormat.getDateTimeInstance(1, 1).format(new Date()) + ")");
            this.addItem("Medium (" + DateFormat.getDateTimeInstance(2, 2).format(new Date()) + ")");
            this.addItem("Short (" + DateFormat.getDateTimeInstance(3, 3).format(new Date()) + ")");
        }

        public void setSelectedIndex(int option) {
            if (option == 3) {
                super.setSelectedIndex(3);
            } else if (option == 2) {
                super.setSelectedIndex(2);
            } else if (option == 1) {
                super.setSelectedIndex(1);
            } else {
                super.setSelectedIndex(0);
            }
        }

        public int getValue() {
            if (this.getSelectedIndex() == 3) {
                return 3;
            }
            if (this.getSelectedIndex() == 2) {
                return 2;
            }
            if (this.getSelectedIndex() == 1) {
                return 1;
            }
            return 0;
        }
    }

    private class KeyTextHandler
    extends KeyAdapter {
        private KeyTextHandler() {
        }

        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeTimestamp.this._textComponent);
            String text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                ((IRestorableTextComponent)((Object)_theComponent)).updateText(text.replaceAll("" + c, ""));
                _theComponent.getToolkit().beep();
                e.consume();
            }
            if (DataTypeTimestamp.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeTimestamp.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeTimestamp.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeTimestamp.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else if (text.length() == 0 && c == '\b' || c == '\u007f') {
                DataTypeTimestamp.this._textComponent.restoreText();
                e.consume();
            }
        }
    }
}

