/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataSetScrollingPanel
extends JScrollPane {
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel = DataSetScrollingPanel.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetScrollingPanel")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel);
    private boolean _fullyCreated = false;
    private IDataSetViewer _viewer;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel$UIUpdater;

    public DataSetScrollingPanel() {
    }

    public DataSetScrollingPanel(String destClassName, IDataSetUpdateableModel updateableModel) throws DataSetException {
        this.createUserInterface(destClassName, updateableModel);
        this._fullyCreated = true;
    }

    public void load(IDataSet ds) {
        this.load(ds, null);
    }

    public void load(IDataSet ds, String destClassName) {
        try {
            if (!this._fullyCreated) {
                this.createUserInterface(destClassName, null);
                this._fullyCreated = true;
            }
            UIUpdater run = new UIUpdater(this._viewer, ds);
            SwingUtilities.invokeLater(run);
        }
        catch (Exception ex) {
            s_log.error("Error", ex);
        }
    }

    public void clear() {
        if (this._viewer != null) {
            this._viewer.clear();
        }
    }

    private void createUserInterface(String destClassName, IDataSetUpdateableModel updateableModel) throws DataSetException {
        this.setBorder(BorderFactory.createEmptyBorder());
        this._viewer = BaseDataSetViewerDestination.getInstance(destClassName, updateableModel);
        Runnable run = new Runnable(){

            public void run() {
                DataSetScrollingPanel.this.setViewportView(DataSetScrollingPanel.this._viewer.getComponent());
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public IDataSetViewer getViewer() {
        return this._viewer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class UIUpdater
    implements Runnable {
        private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel$UIUpdater == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel$UIUpdater = DataSetScrollingPanel.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetScrollingPanel$UIUpdater")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$DataSetScrollingPanel$UIUpdater);
        private final IDataSetViewer _viewer;
        private final IDataSet _ds;

        UIUpdater(IDataSetViewer viewer, IDataSet ds) {
            this._viewer = viewer;
            this._ds = ds;
        }

        public void run() {
            try {
                this._viewer.show(this._ds);
            }
            catch (Throwable th) {
                s_log.error("Error processing a DataSet", th);
            }
        }
    }
}

