/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.PopupEditableIOPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.BaseMDIParentFrame;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CellDataPopup {
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$CellDataPopup;

    public static void showDialog(JTable table, ColumnDisplayDefinition colDef, MouseEvent evt, boolean isModelEditable) {
        CellDataPopup popup = new CellDataPopup();
        popup.createAndShowDialog(table, evt, colDef, isModelEditable);
    }

    private void createAndShowDialog(JTable table, MouseEvent evt, ColumnDisplayDefinition colDef, boolean isModelEditable) {
        ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$datasetviewer$CellDataPopup == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$CellDataPopup = CellDataPopup.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$CellDataPopup);
        Point pt = evt.getPoint();
        int row = table.rowAtPoint(pt);
        int col = table.columnAtPoint(pt);
        Object obj = table.getValueAt(row, col);
        TableCellEditor editor = table.getCellEditor(row, col);
        if (editor != null) {
            editor.cancelCellEditing();
        }
        Component comp = SwingUtilities.getRoot(table);
        TextAreaInternalFrame newComp = null;
        TextAreaInternalFrame taif = new TextAreaInternalFrame(table.getColumnName(col), colDef, obj, row, col, isModelEditable, table);
        ((BaseMDIParentFrame)comp).addInternalFrame(taif, false);
        taif.setLayer(JLayeredPane.POPUP_LAYER);
        taif.pack();
        newComp = taif;
        Dimension dim = newComp.getSize();
        boolean dimChanged = false;
        if (dim.width < 300) {
            dim.width = 300;
            dimChanged = true;
        }
        if (dim.height < 300) {
            dim.height = 300;
            dimChanged = true;
        }
        if (dim.width > 600) {
            dim.width = 600;
            dimChanged = true;
        }
        if (dim.height > 500) {
            dim.height = 500;
            dimChanged = true;
        }
        if (dimChanged) {
            newComp.setSize(dim);
        }
        if (comp instanceof BaseMDIParentFrame) {
            pt = SwingUtilities.convertPoint((Component)evt.getSource(), pt, comp);
            pt.y -= dim.height;
            if (pt.y < 0) {
                pt.y = 0;
            }
        } else {
            Window parent = SwingUtilities.windowForComponent(comp);
            while (parent != null && !(parent instanceof BaseMDIParentFrame) && !parent.equals(comp)) {
                comp = parent;
                parent = SwingUtilities.windowForComponent(comp);
            }
            comp = parent != null ? parent : comp;
            pt = SwingUtilities.convertPoint((Component)evt.getSource(), pt, comp);
        }
        int fudgeFactor = 100;
        Rectangle parentBounds = comp.getBounds();
        if (parentBounds.width <= dim.width + fudgeFactor) {
            dim.width = parentBounds.width - fudgeFactor;
            pt.x = fudgeFactor / 2;
            newComp.setSize(dim);
        } else if (pt.x + dim.width + fudgeFactor > parentBounds.width) {
            pt.x -= pt.x + dim.width + fudgeFactor - parentBounds.width;
        }
        newComp.setLocation(pt);
        ((Component)newComp).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TextAreaInternalFrame
    extends JInternalFrame {
        public TextAreaInternalFrame(String columnName, ColumnDisplayDefinition colDef, Object value, int row, int col, boolean isModelEditable, JTable table) {
            super("Value of column " + columnName, true, true, true, true);
            ColumnDataPopupPanel popup = new ColumnDataPopupPanel(value, colDef, isModelEditable);
            popup.setUserActionInfo(this, row, col, table);
            this.setContentPane(popup);
        }
    }

    private static class ColumnDataPopupPanel
    extends JPanel {
        private final PopupEditableIOPanel ioPanel;
        private JInternalFrame _parentFrame = null;
        private int _row;
        private int _col;
        private JTable _table;

        ColumnDataPopupPanel(Object cellContents, ColumnDisplayDefinition colDef, boolean tableIsEditable) {
            super(new BorderLayout());
            if (tableIsEditable && CellComponentFactory.isEditableInPopup(colDef, cellContents)) {
                this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, true);
                JPanel editingControls = this.createPopupEditingControls(this.ioPanel, colDef);
                this.add((Component)editingControls, "South");
            } else {
                this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, false);
            }
            this.add((Component)this.ioPanel, "Center");
        }

        private JPanel createPopupEditingControls(PopupEditableIOPanel ioPanel, ColumnDisplayDefinition colDef) {
            ColumnDisplayDefinition _colDef = colDef;
            JPanel panel = new JPanel(new BorderLayout());
            JPanel updateControls = new JPanel();
            JButton updateButton = new JButton("Update Data");
            updateButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ColumnDataPopupPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent event) {
                    StringBuffer messageBuffer = new StringBuffer();
                    Object newValue = ColumnDataPopupPanel.access$000(this.this$0).getObject(messageBuffer);
                    if (messageBuffer.length() > 0) {
                        messageBuffer.insert(0, "The given text cannot be converted into the internal object.\nPlease change the data or cancel editing.\nThe conversion error was:\n");
                        JOptionPane.showMessageDialog(this.this$0, messageBuffer, "Conversion Error", 0);
                        ColumnDataPopupPanel.access$000(this.this$0).requestFocus();
                    } else {
                        ColumnDataPopupPanel.access$300(this.this$0).setValueAt(newValue, ColumnDataPopupPanel.access$100(this.this$0), ColumnDataPopupPanel.access$200(this.this$0));
                        ColumnDataPopupPanel.access$400(this.this$0).setVisible(false);
                        ColumnDataPopupPanel.access$400(this.this$0).dispose();
                    }
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ColumnDataPopupPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent event) {
                    ColumnDataPopupPanel.access$400(this.this$0).setVisible(false);
                    ColumnDataPopupPanel.access$400(this.this$0).dispose();
                }
            });
            updateControls.add(updateButton);
            updateControls.add(cancelButton);
            panel.add((Component)updateControls, "South");
            return panel;
        }

        public void setUserActionInfo(JInternalFrame parent, int row, int col, JTable table) {
            this._parentFrame = parent;
            this._row = row;
            this._col = col;
            this._table = table;
        }

        static /* synthetic */ PopupEditableIOPanel access$000(ColumnDataPopupPanel x0) {
            return x0.ioPanel;
        }

        static /* synthetic */ int access$100(ColumnDataPopupPanel x0) {
            return x0._row;
        }

        static /* synthetic */ int access$200(ColumnDataPopupPanel x0) {
            return x0._col;
        }

        static /* synthetic */ JTable access$300(ColumnDataPopupPanel x0) {
            return x0._table;
        }

        static /* synthetic */ JInternalFrame access$400(ColumnDataPopupPanel x0) {
            return x0._parentFrame;
        }
    }
}

