/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.util;

import java.util.StringTokenizer;

public class QueryTokenizer {
    private static String _alternateQuerySeparator;
    private static String _querySeparator;
    private String _sQuerys;
    private String _sNextQuery;
    private String _solComment;

    public QueryTokenizer(String sql, String querySeparator, String alternateSeparator, String solComment) {
        _querySeparator = querySeparator != null && querySeparator.trim().length() > 0 ? querySeparator.substring(0, 1) : ";";
        _alternateQuerySeparator = alternateSeparator != null && alternateSeparator.trim().length() > 0 ? alternateSeparator : null;
        this._solComment = solComment != null && solComment.trim().length() > 0 ? solComment : null;
        if (sql != null) {
            this._sQuerys = this.prepareSQL(sql);
            this._sNextQuery = this.parse();
        } else {
            this._sQuerys = "";
        }
    }

    public boolean hasQuery() {
        return this._sNextQuery != null;
    }

    public String nextQuery() {
        String sReturnQuery = this._sNextQuery;
        this._sNextQuery = this.parse();
        return sReturnQuery;
    }

    private int findFirstSeparator() {
        String separator = _querySeparator;
        int separatorLength = _querySeparator.length();
        int iQuoteCount = 1;
        int iIndex1 = 0 - separatorLength;
        while (iQuoteCount % 2 != 0) {
            iQuoteCount = 0;
            if ((iIndex1 = this._sQuerys.indexOf(separator, iIndex1 + separatorLength)) > -1) {
                int iIndex2 = this._sQuerys.lastIndexOf(39, iIndex1 + separatorLength - 1);
                while (iIndex2 != -1) {
                    if (this._sQuerys.charAt(iIndex2 - 1) != '\\') {
                        ++iQuoteCount;
                    }
                    iIndex2 = this._sQuerys.lastIndexOf(39, iIndex2 - 1);
                }
                continue;
            }
            return -1;
        }
        return iIndex1;
    }

    private int findFirstAlternateSeparator() {
        if (_alternateQuerySeparator == null) {
            return -1;
        }
        String separator = _alternateQuerySeparator;
        int separatorLength = _alternateQuerySeparator.length();
        int iQuoteCount = 1;
        int iIndex1 = 0 - separatorLength;
        while (iQuoteCount % 2 != 0) {
            iQuoteCount = 0;
            if ((iIndex1 = this._sQuerys.indexOf(separator, iIndex1 + separatorLength)) > -1) {
                int iIndex2 = this._sQuerys.lastIndexOf(39, iIndex1 + separatorLength - 1);
                while (iIndex2 != -1) {
                    if (this._sQuerys.charAt(iIndex2 - 1) != '\\') {
                        ++iQuoteCount;
                    }
                    iIndex2 = this._sQuerys.lastIndexOf(39, iIndex2 - 1);
                }
                continue;
            }
            return -1;
        }
        return iIndex1;
    }

    public String parse() {
        if (this._sQuerys.length() == 0) {
            return null;
        }
        String separator = _querySeparator;
        int indexSep = this.findFirstSeparator();
        int indexAltSep = this.findFirstAlternateSeparator();
        if (indexAltSep > -1 && (indexSep < 0 || indexAltSep < indexSep)) {
            separator = _alternateQuerySeparator;
        }
        int separatorLength = separator.length();
        int iQuoteCount = 1;
        int iIndex1 = 0 - separatorLength;
        while (iQuoteCount % 2 != 0) {
            iQuoteCount = 0;
            if ((iIndex1 = this._sQuerys.indexOf(separator, iIndex1 + separatorLength)) > -1) {
                int iIndex2 = this._sQuerys.lastIndexOf(39, iIndex1 + separatorLength - 1);
                while (iIndex2 != -1) {
                    if (this._sQuerys.charAt(iIndex2 - 1) != '\\') {
                        ++iQuoteCount;
                    }
                    iIndex2 = this._sQuerys.lastIndexOf(39, iIndex2 - 1);
                }
                continue;
            }
            String sNextQuery = this._sQuerys;
            this._sQuerys = "";
            if (this._solComment != null && sNextQuery.startsWith(this._solComment)) {
                return this.parse();
            }
            return this.replaceLineFeeds(sNextQuery);
        }
        String sNextQuery = this._sQuerys.substring(0, iIndex1);
        this._sQuerys = this._sQuerys.substring(iIndex1 + separatorLength).trim();
        if (this._solComment != null && sNextQuery.startsWith(this._solComment)) {
            return this.parse();
        }
        return this.replaceLineFeeds(sNextQuery);
    }

    private String prepareSQL(String sql) {
        StringBuffer results = new StringBuffer(1024);
        StringTokenizer tok = new StringTokenizer(sql.trim(), "\n", false);
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            if (line.startsWith(this._solComment)) continue;
            results.append(line).append('\n');
        }
        return results.toString();
    }

    private String replaceLineFeeds(String sql) {
        StringBuffer sbReturn = new StringBuffer();
        int iPrev = 0;
        int linefeed = sql.indexOf(10);
        int iQuote = -1;
        while (linefeed != -1) {
            if ((iQuote = sql.indexOf(39, iQuote + 1)) != -1 && iQuote < linefeed) {
                int iNextQute = sql.indexOf(39, iQuote + 1);
                if (iNextQute <= linefeed) continue;
                sbReturn.append(sql.substring(iPrev, linefeed));
                sbReturn.append('\n');
                iPrev = linefeed + 1;
                linefeed = sql.indexOf(10, iPrev);
                continue;
            }
            linefeed = sql.indexOf(10, linefeed + 1);
        }
        sbReturn.append(sql.substring(iPrev));
        return sbReturn.toString();
    }
}

