/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.util;

import java.net.URL;
import java.util.HashMap;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.URLUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageUtil {
    private static HashMap _imageCount = new HashMap();
    private static HashMap _images = new HashMap();

    public static void disposeImage(String propertyName) {
        try {
            Image image = (Image)_images.get(propertyName);
            if (image == null) {
                return;
            }
            image.dispose();
            _images.remove(propertyName);
            Integer handleCount = (Integer)_imageCount.get(propertyName);
            handleCount = handleCount == null ? new Integer(0) : new Integer(handleCount - 1);
            _imageCount.put(propertyName, handleCount);
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error disposing images", e);
        }
    }

    public static ImageDescriptor getDescriptor(String propertyName) {
        String path;
        block5: {
            block4: {
                try {
                    if (propertyName != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    SQLExplorerPlugin.error("Couldn't create image for " + propertyName, e);
                    return null;
                }
            }
            path = Messages.getString(propertyName);
            if (path != null && path.trim().length() != 0) break block5;
            SQLExplorerPlugin.error("Missing image path for " + propertyName, null);
            return null;
        }
        URL url = URLUtil.getResourceURL(path);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static ImageDescriptor getFragmentDescriptor(String fragmentId, String path) {
        block3: {
            try {
                if (path != null && path.trim().length() != 0) break block3;
                return null;
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Couldn't create image for " + fragmentId + ": " + path, e);
                return null;
            }
        }
        URL url = URLUtil.getFragmentResourceURL(fragmentId, path);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static Image getImage(String propertyName) {
        Integer handleCount;
        Image image = (Image)_images.get(propertyName);
        if (image == null) {
            image = ImageUtil.getDescriptor(propertyName).createImage();
            if (image == null) {
                return null;
            }
            _images.put(propertyName, image);
        }
        handleCount = (handleCount = (Integer)_imageCount.get(propertyName)) == null ? new Integer(1) : new Integer(handleCount + 1);
        _imageCount.put(propertyName, handleCount);
        return image;
    }

    public static Image getFragmentImage(String fragmentId, String path) {
        ImageDescriptor descriptor;
        block5: {
            block4: {
                try {
                    if (path != null && path.trim().length() != 0) break block4;
                    return null;
                }
                catch (Exception e) {
                    SQLExplorerPlugin.error("Couldn't create image for " + fragmentId + ": " + path, e);
                    return null;
                }
            }
            URL url = URLUtil.getFragmentResourceURL(fragmentId, path);
            descriptor = ImageDescriptor.createFromURL((URL)url);
            if (descriptor != null) break block5;
            return null;
        }
        return descriptor.createImage();
    }
}

