/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqlpanel;

import java.sql.ResultSet;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dataset.DataSetTable;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.views.SqlResultsView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sqlpanel.AbstractSQLExecution;
import net.sourceforge.sqlexplorer.sqlpanel.SQLResult;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SQLExecution
extends AbstractSQLExecution {
    protected int _maxRows;
    protected SQLResult _sqlResult;
    protected Statement _stmt;

    public SQLExecution(SQLEditor editor, SqlResultsView resultsView, String sqlString, int maxRows, SessionTreeNode sessionTreeNode) {
        this._editor = editor;
        this._sqlStatement = sqlString;
        this._maxRows = maxRows;
        this._session = sessionTreeNode;
        this._resultsView = resultsView;
        this._sqlResult = new SQLResult();
        this._sqlResult.setSqlStatement(this._sqlStatement);
        this.setProgressMessage(Messages.getString("SQLResultsView.ConnectionWait"));
    }

    protected void displayResults() {
        this._resultsView.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SQLExecution.this.clearCanvas();
                GridLayout gLayout = new GridLayout();
                gLayout.numColumns = 2;
                gLayout.marginLeft = 0;
                gLayout.horizontalSpacing = 0;
                gLayout.verticalSpacing = 0;
                gLayout.marginWidth = 0;
                gLayout.marginHeight = 0;
                SQLExecution.this._composite.setLayout((Layout)gLayout);
                try {
                    String statusMessage = String.valueOf(Messages.getString("SQLResultsView.Time.Prefix")) + " " + SQLExecution.this._sqlResult.getExecutionTimeMillis() + " " + Messages.getString("SQLResultsView.Time.Postfix");
                    new DataSetTable(SQLExecution.this._composite, SQLExecution.this._sqlResult.getDataSet(), statusMessage);
                    SQLExecution.this._composite.setData("parenttab", (Object)SQLExecution.this._parentTab);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    Label errorLabel = new Label(SQLExecution.this._composite, 4);
                    errorLabel.setText(message);
                    errorLabel.setLayoutData((Object)new GridData(4, 128, true, false));
                    SQLExplorerPlugin.error("Error creating result tab", e);
                }
                SQLExecution.this._composite.layout();
                SQLExecution.this._composite.redraw();
                SQLExecution.this.setProgressMessage(Messages.getString("SQLResultsView.ConnectionWait"));
            }
        });
    }

    private void closeStatement() {
        if (this._stmt == null) {
            return;
        }
        if (this._stmt != null) {
            try {
                this._stmt.close();
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Error closing statement.", e);
            }
        }
        this._stmt = null;
    }

    protected void doExecution() throws Exception {
        final long startTime = System.currentTimeMillis();
        try {
            this._stmt = this._connection.createStatement();
            this.setProgressMessage(Messages.getString("SQLResultsView.Executing"));
            this._stmt.setMaxRows(this._maxRows);
            if (this._isCancelled) {
                return;
            }
            boolean b = this._stmt.execute(this._sqlStatement);
            if (this._isCancelled) {
                this.closeStatement();
                return;
            }
            if (b) {
                ResultSet rs = this._stmt.getResultSet();
                if (rs != null) {
                    if (this._isCancelled) {
                        this.closeStatement();
                        return;
                    }
                    DataSet dataSet = new DataSet(null, rs, null);
                    final long endTime = System.currentTimeMillis();
                    this._sqlResult.setDataSet(dataSet);
                    this._sqlResult.setExecutionTimeMillis(endTime - startTime);
                    SQLExplorerPlugin.getDefault().getSQLHistory().addSQL(this._sqlStatement, this._session.toString());
                    this.closeStatement();
                    if (this._isCancelled) {
                        return;
                    }
                    this.displayResults();
                    this._composite.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            String message = String.valueOf(Messages.getString("SQLEditor.TotalTime.Prefix")) + " " + (int)(endTime - startTime) + " " + Messages.getString("SQLEditor.TotalTime.Postfix");
                            if (SQLExecution.this._editor != null) {
                                SQLExecution.this._editor.setMessage(message);
                            }
                        }
                    });
                }
            } else {
                final long endTime = System.currentTimeMillis();
                final int updateCount = this._stmt.getUpdateCount();
                this._composite.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        String message = updateCount + " " + Messages.getString("SQLEditor.Update.Prefix") + " " + (int)(endTime - startTime) + " " + Messages.getString("SQLEditor.Update.Postfix");
                        if (SQLExecution.this._editor != null) {
                            SQLExecution.this._editor.setMessage(message);
                        }
                        SQLExecution.this._parentTab.dispose();
                    }
                });
                this.closeStatement();
                if (this._isCancelled) {
                    return;
                }
                SQLExplorerPlugin.getDefault().getSQLHistory().addSQL(this._sqlStatement, this._session.toString());
            }
            this._stmt = null;
        }
        catch (Exception e) {
            this.closeStatement();
            throw e;
        }
    }

    public void doStop() {
        if (this._stmt != null) {
            try {
                this._stmt.cancel();
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Error cancelling statement.", e);
            }
            try {
                this.closeStatement();
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Error closing statement.", e);
            }
        }
    }
}

