/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SQLEditorCatalogSwitcher
extends ControlContribution {
    private SQLEditor _editor;
    private Combo _catalogCombo;

    public SQLEditorCatalogSwitcher(SQLEditor editor) {
        super("net.sourceforge.sqlexplorer.catalogswitcher");
        this._editor = editor;
    }

    protected Control createControl(Composite parent) {
        this._catalogCombo = new Combo(parent, 8);
        this._catalogCombo.setToolTipText(Messages.getString("SQLEditor.Actions.ChooseCatalog.ToolTip"));
        this._catalogCombo.setSize(200, this._catalogCombo.getSize().y);
        this._catalogCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selIndex = SQLEditorCatalogSwitcher.this._catalogCombo.getSelectionIndex();
                String newCat = SQLEditorCatalogSwitcher.this._catalogCombo.getItem(selIndex);
                if (SQLEditorCatalogSwitcher.this._editor.getSessionTreeNode() != null) {
                    try {
                        SQLEditorCatalogSwitcher.this._editor.getSessionTreeNode().setCatalog(newCat);
                    }
                    catch (Exception e1) {
                        SQLExplorerPlugin.error("Error changing catalog", e1);
                    }
                }
            }
        });
        this._catalogCombo.add("");
        if (this._editor.getSessionTreeNode() != null && this._editor.getSessionTreeNode().supportsCatalogs()) {
            String[] catalogs = this._editor.getSessionTreeNode().getRoot().getChildNames();
            String currentCatalog = this._editor.getSessionTreeNode().getCatalog();
            int i = 0;
            while (i < catalogs.length) {
                this._catalogCombo.add(catalogs[i]);
                if (currentCatalog.equals(catalogs[i])) {
                    this._catalogCombo.select(this._catalogCombo.getItemCount() - 1);
                }
                ++i;
            }
        }
        return this._catalogCombo;
    }
}

