/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.model.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.nodes.CatalogNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.DatabaseNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.SchemaNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.DoublyLinkedList;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.TernarySearchTree;
import net.sourceforge.sqlexplorer.sqleditor.SQLCodeScanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

public class Dictionary {
    private static final String[] SUPPORTED_CONTENT_ASSIST_TYPES = new String[]{"TABLE_TYPE", "VIEW_TYPE"};
    private static final Log _logger;
    private static TernarySearchTree keywordsTree;
    private TernarySearchTree tree = new TernarySearchTree();
    private TernarySearchTree catalogSchemaTree = new TernarySearchTree();
    private TernarySearchTree externalObjectTree = new TernarySearchTree();
    private HashMap realTables = new HashMap();
    private HashMap realCatalogSchemas = new HashMap();
    private HashMap realExternalObjects = new HashMap();
    private HashMap col_map = new HashMap();
    private static int ROOT_WORK_UNIT;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = LogFactory.getLog((Class)clazz);
        keywordsTree = new TernarySearchTree();
        String[] str = SQLCodeScanner.getFgKeywords();
        int i = 0;
        while (i < str.length) {
            keywordsTree.put(str[i], str[i]);
            ++i;
        }
        ROOT_WORK_UNIT = 1000;
    }

    public void putTableName(String key, Object value) {
        this.tree.put(key.toLowerCase(), value);
        this.realTables.put(key.toLowerCase(), key);
    }

    public void putCatalogSchemaName(String key, Object value) {
        this.catalogSchemaTree.put(key.toLowerCase(), value);
        this.realCatalogSchemas.put(key.toLowerCase(), key);
    }

    public void putExternalObjectName(String key, Object value) {
        this.externalObjectTree.put(key.toLowerCase(), value);
        this.realExternalObjects.put(key.toLowerCase(), key);
    }

    public Object getByTableName(String key) {
        return this.tree.get(key);
    }

    public Object getByCatalogSchemaName(String key) {
        return this.catalogSchemaTree.get(key);
    }

    public Object getByExternalObjectName(String key) {
        return this.catalogSchemaTree.get(key);
    }

    public void putColumnsByTableName(String key, Object value) {
        this.col_map.put(key, value);
    }

    public Object getColumnListByTableName(String key) {
        return this.col_map.get(key);
    }

    public Iterator getTableNames() {
        return this.realTables.keySet().iterator();
    }

    public Iterator getCatalogSchemaNames() {
        return this.realCatalogSchemas.keySet().iterator();
    }

    public Iterator getExternalObjectNames() {
        return this.realExternalObjects.keySet().iterator();
    }

    public ArrayList getTableObjectList(String tableName) {
        return (ArrayList)this.tree.get(tableName.toLowerCase());
    }

    public String[] matchTablePrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = this.tree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)this.realTables.get(iterator.next());
        }
        return result;
    }

    public String[] matchCatalogSchemaPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = this.catalogSchemaTree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)this.realCatalogSchemas.get(iterator.next());
        }
        return result;
    }

    public String[] matchExternalObjectPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = this.externalObjectTree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)this.realExternalObjects.get(iterator.next());
        }
        return result;
    }

    public static String[] matchKeywordsPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = keywordsTree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)iterator.next();
        }
        return result;
    }

    public boolean restore(DatabaseNode dbNode, IProgressMonitor monitor) throws InterruptedException {
        return false;
    }

    public void store() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(DatabaseNode dbNode, IProgressMonitor monitor) throws InterruptedException {
        block10: {
            block9: {
                try {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException(Messages.getString("Progress.Dictionary.Cancelled"));
                    }
                    INode[] children = dbNode.getChildNodes();
                    if (children == null) {
                        Object var6_4 = null;
                        break block9;
                    }
                    monitor.beginTask(dbNode.getSession().toString(), children.length * ROOT_WORK_UNIT);
                    int i = 0;
                    while (true) {
                        if (i >= children.length) {
                            this.store();
                            break block10;
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException(Messages.getString("Progress.Dictionary.Cancelled"));
                        }
                        INode node = children[i];
                        if (node instanceof SchemaNode || node instanceof CatalogNode) {
                            this.loadSchemaCatalog(node, monitor);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var6_6 = null;
        monitor.done();
    }

    private void loadSchemaCatalog(INode iNode, IProgressMonitor monitor) throws InterruptedException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Loading dictionary: " + iNode.getName()));
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException(Messages.getString("Progress.Dictionary.Cancelled"));
        }
        this.putCatalogSchemaName(iNode.toString(), iNode);
        monitor.subTask(iNode.getName());
        INode[] children = iNode.getChildNodes();
        if (children != null) {
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.getString("Progress.Dictionary.Cancelled"));
            }
            int typeNodeWorkUnit = ROOT_WORK_UNIT / SUPPORTED_CONTENT_ASSIST_TYPES.length;
            int typeNodeWorkCompleted = 0;
            int i = 0;
            while (i < children.length) {
                INode typeNode = children[i];
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Loading dictionary: " + typeNode.getName()));
                }
                boolean isIncludedInContentAssist = false;
                int j = 0;
                while (j < SUPPORTED_CONTENT_ASSIST_TYPES.length) {
                    if (typeNode.getType().equalsIgnoreCase(SUPPORTED_CONTENT_ASSIST_TYPES[j])) {
                        isIncludedInContentAssist = true;
                    }
                    ++j;
                }
                if (isIncludedInContentAssist) {
                    monitor.subTask(typeNode.getName());
                    if (monitor.isCanceled()) {
                        throw new InterruptedException(Messages.getString("Progress.Dictionary.Cancelled"));
                    }
                    INode[] tableNodes = typeNode.getChildNodes();
                    if (tableNodes != null) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException(Messages.getString("Progress.Dictionary.Cancelled"));
                        }
                        int tableNodeWorkUnit = typeNodeWorkUnit / tableNodes.length;
                        int j2 = 0;
                        while (j2 < tableNodes.length) {
                            ArrayList<INode> tableDetails;
                            INode tableNode = tableNodes[j2];
                            if (_logger.isDebugEnabled()) {
                                _logger.debug((Object)("Loading dictionary: " + tableNode.getName()));
                            }
                            if (monitor != null) {
                                monitor.worked(tableNodeWorkUnit);
                                typeNodeWorkCompleted += tableNodeWorkUnit;
                                if (_logger.isDebugEnabled()) {
                                    _logger.debug((Object)("worked table: " + tableNodeWorkUnit + ", total type work: " + typeNodeWorkCompleted));
                                }
                                monitor.subTask(tableNode.getQualifiedName());
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException(Messages.getString("Progress.Dictionary.Cancelled"));
                                }
                            }
                            if ((tableDetails = (ArrayList<INode>)this.getByTableName(tableNode.getName())) == null) {
                                tableDetails = new ArrayList<INode>();
                                this.putTableName(tableNode.getName(), tableDetails);
                            }
                            tableDetails.add(tableNode);
                            if (tableNode instanceof TableNode) {
                                TreeSet columnNames = new TreeSet();
                                List columns = ((TableNode)tableNode).getColumnNames();
                                if (columns != null) {
                                    Iterator it = columns.iterator();
                                    while (it.hasNext()) {
                                        columnNames.add(it.next());
                                    }
                                }
                                this.putColumnsByTableName(tableNode.getName(), columnNames);
                            }
                            ++j2;
                        }
                    }
                    if (typeNodeWorkCompleted < typeNodeWorkUnit) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("consuming remainder: " + (typeNodeWorkUnit - typeNodeWorkCompleted)));
                        }
                        monitor.worked(typeNodeWorkUnit - typeNodeWorkCompleted);
                    }
                    typeNodeWorkCompleted = 0;
                }
                ++i;
            }
        }
    }
}

