/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.dbdetail.DetailTabManager;
import net.sourceforge.sqlexplorer.dbstructure.DatabaseModel;
import net.sourceforge.sqlexplorer.dbstructure.nodes.DatabaseNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeClosedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.DictionaryLoader;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.widgets.Table;

public class SessionTreeNode
implements ISessionTreeNode {
    private ISQLAlias _alias;
    boolean _assistanceEnabled;
    private SQLConnection _backgroundConnection;
    private SQLConnection _interactiveConnection;
    private boolean _backgroundConnectionInUse = false;
    private List _connectionNumberQueue = new ArrayList();
    private long _created;
    private Dictionary _dictionary = new Dictionary();
    private IIdentifier _id = IdentifierFactory.getInstance().createIdentifier();
    private ListenerList _listeners = new ListenerList();
    private SQLDatabaseMetaData _metaData = null;
    private SessionTreeModel _model;
    private int _nextConnectionNumber = 0;
    private RootSessionTreeNode _parent;
    private final String _password;
    public DatabaseModel dbModel;
    private ArrayList ls = new ArrayList(10);
    Table table;
    private static final int COMMIT_REQUEST = -1;
    private static final int ROLLBACK_REQUEST = -2;
    private static final int CATALOG_CHANGE_REQUEST = -3;
    private String _newCatalog;
    private static final Log _logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = LogFactory.getLog((Class)clazz);
    }

    public SessionTreeNode(SQLConnection[] conn, ISQLAlias alias, SessionTreeModel md, IProgressMonitor monitor, String password) throws InterruptedException {
        this._created = System.currentTimeMillis();
        this._interactiveConnection = conn[0];
        this._backgroundConnection = conn[1];
        this._alias = alias;
        this.dbModel = new DatabaseModel(this);
        this._model = md;
        this._parent = md.getRoot();
        this._parent.add(this);
        this._password = password;
        this._assistanceEnabled = SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.Assist");
        if (this._assistanceEnabled) {
            DictionaryLoader dictionaryLoader = new DictionaryLoader(this);
            dictionaryLoader.schedule(500L);
        }
    }

    public void add(ISessionTreeNode n) {
        this.ls.add(n);
    }

    public SQLConnection getInteractiveConnection() {
        return this._interactiveConnection;
    }

    public void addListener(ISessionTreeClosedListener listener) {
        this._listeners.add((Object)listener);
    }

    public void close() {
        this._dictionary.store();
        DetailTabManager.clearCacheForSession(this);
        this._parent.remove(this);
        Object[] ls = this._listeners.getListeners();
        int i = 0;
        while (i < ls.length) {
            try {
                ((ISessionTreeClosedListener)ls[i]).sessionTreeClosed();
            }
            catch (Throwable throwable) {}
            ++i;
        }
        this._model.modelChanged(null);
        try {
            this._interactiveConnection.close();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error closing interactive database connection", e);
        }
        try {
            this._backgroundConnection.close();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error closing background database connection", e);
        }
    }

    public synchronized void commit() {
        try {
            if (this._connectionNumberQueue.size() == 0 && !this._backgroundConnectionInUse) {
                this._backgroundConnection.commit();
            } else {
                this._connectionNumberQueue.add(new Integer(-1));
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error committing ", e);
        }
    }

    public ISQLAlias getAlias() {
        return this._alias;
    }

    public String getCatalog() {
        String cat = "";
        try {
            cat = this._interactiveConnection.getCatalog();
        }
        catch (Throwable throwable) {}
        return cat;
    }

    public String[] getCatalogs() {
        List catalogs = ((DatabaseNode)this.dbModel.getChildNodes()[0]).getCatalogs();
        String[] catalogNames = new String[catalogs.size()];
        Iterator it = catalogs.iterator();
        int i = 0;
        while (it.hasNext()) {
            INode node = (INode)it.next();
            if (node == null) continue;
            catalogNames[i] = node.toString();
            ++i;
        }
        return catalogNames;
    }

    public Object[] getChildren() {
        return this.ls.toArray();
    }

    public long getCreated() {
        return this._created;
    }

    public String getCurrentConnectionPassword() {
        return this._password;
    }

    public Dictionary getDictionary() {
        return this._dictionary;
    }

    public IIdentifier getIdentifier() {
        return this._id;
    }

    public SQLDatabaseMetaData getMetaData() {
        if (this._metaData == null) {
            this._metaData = this._interactiveConnection.getSQLMetaData();
        }
        return this._metaData;
    }

    public Object getParent() {
        return this._parent;
    }

    public synchronized SQLConnection getQueuedConnection(Integer number) {
        if (this._backgroundConnectionInUse || number == null) {
            return null;
        }
        Integer currentNumber = (Integer)this._connectionNumberQueue.get(0);
        if (currentNumber.intValue() == number.intValue()) {
            this._backgroundConnectionInUse = true;
            _logger.debug((Object)("Connection " + number + " acquired."));
            return this._backgroundConnection;
        }
        return null;
    }

    public synchronized Integer getQueuedConnectionNumber() {
        Integer number = new Integer(this._nextConnectionNumber);
        this._connectionNumberQueue.add(number);
        ++this._nextConnectionNumber;
        return number;
    }

    public DatabaseNode getRoot() {
        return this.dbModel.getRoot();
    }

    public boolean isAutoCommitMode() {
        boolean result = false;
        try {
            result = this._interactiveConnection.getAutoCommit();
        }
        catch (Throwable throwable) {}
        return result;
    }

    public synchronized void releaseQueuedConnection(Integer number) {
        if (number == null) {
            return;
        }
        if (this._connectionNumberQueue.indexOf(number) == 0) {
            this._backgroundConnectionInUse = false;
            this._connectionNumberQueue.remove(0);
            _logger.debug((Object)("Connection " + number + " released."));
            while (this._connectionNumberQueue.size() > 0) {
                int nextNumber = (Integer)this._connectionNumberQueue.get(0);
                try {
                    if (nextNumber == -1) {
                        _logger.debug((Object)"Committing.");
                        this._connectionNumberQueue.remove(0);
                        this._backgroundConnection.commit();
                        continue;
                    }
                    if (nextNumber == -2) {
                        _logger.debug((Object)"Rolling back.");
                        this._connectionNumberQueue.remove(0);
                        this._backgroundConnection.rollback();
                        continue;
                    }
                    if (nextNumber == -3) {
                        _logger.debug((Object)"Changing catalog.");
                        this._connectionNumberQueue.remove(0);
                        this._backgroundConnection.setCatalog(this._newCatalog);
                        continue;
                    }
                    break;
                }
                catch (Exception e) {
                    _logger.error((Object)"Couldn't perform commit/rollback or catalog change.", (Throwable)e);
                }
            }
        } else {
            this._connectionNumberQueue.remove(number);
            _logger.debug((Object)("Connection request " + number + " removed from queue."));
        }
    }

    public void remove(ISessionTreeNode n) {
        this.ls.remove(n);
    }

    public synchronized void rollback() {
        try {
            if (this._connectionNumberQueue.size() == 0 && !this._backgroundConnectionInUse) {
                this._backgroundConnection.rollback();
            } else {
                this._connectionNumberQueue.add(new Integer(-2));
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error rollbacking ", e);
        }
    }

    public synchronized void setCatalog(String cat) throws SQLException {
        this._interactiveConnection.setCatalog(cat);
        if (this._connectionNumberQueue.size() == 0 && !this._backgroundConnectionInUse) {
            this._backgroundConnection.setCatalog(cat);
        } else {
            this._newCatalog = cat;
            this._connectionNumberQueue.add(new Integer(-3));
        }
    }

    public boolean supportsCatalogs() {
        return this.getRoot().supportsCatalogs();
    }

    public String toString() {
        try {
            return this._alias.getName();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting the alias name ", e);
            return "";
        }
    }
}

