/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.rcp;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.rcp.SQLExplorerActionBarAdvisor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class SQLExplorerWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public SQLExplorerWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        IWorkbenchWindowConfigurer windowConfigurer = this.getWindowConfigurer();
        windowConfigurer.setTitle(Messages.getString("Application.SQLExplorer.WindowTitle"));
        windowConfigurer.setShowCoolBar(false);
        windowConfigurer.setShowPerspectiveBar(false);
        windowConfigurer.setShowProgressIndicator(true);
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        IWorkbenchWindowConfigurer windowConfigurer = this.getWindowConfigurer();
        windowConfigurer.setShowCoolBar(false);
        IMenuManager menuBar = windowConfigurer.getActionBarConfigurer().getMenuManager();
        this.hideMenuItem(menuBar, "file", "converstLineDelimitersTo");
        this.hideMenuItem(menuBar, "file", "org.eclipse.ui.edit.text.openExternalFile");
        this.hideMenuItem(menuBar, "help", "org.eclipse.ui.actionSet.keyBindings");
        this.hideMenuItem(menuBar, "help", "org.eclipse.ui.actions.showKeyAssistHandler");
        menuBar.updateAll(true);
    }

    private void hideMenuItem(IMenuManager menuBar, String menupath, String id) {
        IMenuManager menu = menuBar.findMenuUsingPath(menupath);
        if (menu == null) {
            return;
        }
        IContributionItem item = menu.findUsingPath(id);
        if (item != null) {
            item.setVisible(false);
        }
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new SQLExplorerActionBarAdvisor(configurer);
    }
}

