/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.preferences;

import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dialogs.CreateDriverDlg;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.preferences.DriverContentProvider;
import net.sourceforge.sqlexplorer.preferences.DriverLabelProvider;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DriverPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer _tableViewer;
    private Font _boldfont;
    private IPreferenceStore _prefs;
    private DriverModel _driverModel;

    public DriverPreferencePage() {
    }

    public DriverPreferencePage(String title) {
        super(title);
    }

    public DriverPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this._driverModel = SQLExplorerPlugin.getDefault().getDriverModel();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "net.sourceforge.sqlexplorer.DriverContainerGroup");
        this._prefs = SQLExplorerPlugin.getDefault().getPreferenceStore();
        GridLayout parentLayout = new GridLayout(1, false);
        parentLayout.marginBottom = 0;
        parentLayout.marginTop = 0;
        parentLayout.marginHeight = 0;
        parentLayout.verticalSpacing = 10;
        parent.setLayout((Layout)parentLayout);
        Composite myComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        myComposite.setLayout((Layout)layout);
        myComposite.setLayoutData((Object)new GridData(4, 16384, true, true));
        GridData gid = new GridData(1808);
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        gid.verticalSpan = 6;
        this._tableViewer = new TableViewer(myComposite, 2816);
        this._tableViewer.getControl().setLayoutData((Object)gid);
        this._tableViewer.setContentProvider((IContentProvider)new DriverContentProvider());
        final DriverLabelProvider dlp = new DriverLabelProvider();
        this._tableViewer.setLabelProvider((IBaseLabelProvider)dlp);
        this._tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dlp.dispose();
                if (DriverPreferencePage.this._boldfont != null) {
                    DriverPreferencePage.this._boldfont.dispose();
                }
            }
        });
        this._tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DriverPreferencePage.this.changeDriver();
            }
        });
        this._tableViewer.setInput((Object)this._driverModel);
        this.selectFirst();
        final Table table = this._tableViewer.getTable();
        myComposite.layout();
        parent.layout();
        gid = new GridData(4);
        gid.widthHint = 75;
        Button add = new Button(myComposite, 8);
        add.setText(Messages.getString("Preferences.Drivers.Button.Add"));
        add.setLayoutData((Object)gid);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdentifierFactory factory = IdentifierFactory.getInstance();
                ISQLDriver driver = DriverPreferencePage.this._driverModel.createDriver(factory.createIdentifier());
                CreateDriverDlg dlg = new CreateDriverDlg(DriverPreferencePage.this.getShell(), DriverPreferencePage.this._driverModel, 1, driver);
                dlg.open();
                DriverPreferencePage.this._tableViewer.refresh();
                DriverPreferencePage.this.selectFirst();
            }
        });
        gid = new GridData(4);
        gid.widthHint = 75;
        Button edit = new Button(myComposite, 8);
        edit.setText(Messages.getString("Preferences.Drivers.Button.Edit"));
        edit.setLayoutData((Object)gid);
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferencePage.this.changeDriver();
            }
        });
        gid = new GridData(4);
        gid.widthHint = 75;
        Button copy = new Button(myComposite, 8);
        copy.setText(Messages.getString("Preferences.Drivers.Button.Copy"));
        copy.setLayoutData((Object)gid);
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)DriverPreferencePage.this._tableViewer.getSelection();
                ISQLDriver dv = (ISQLDriver)sel.getFirstElement();
                if (dv != null) {
                    CreateDriverDlg dlg = new CreateDriverDlg(DriverPreferencePage.this.getShell(), DriverPreferencePage.this._driverModel, 3, dv);
                    dlg.open();
                    DriverPreferencePage.this._tableViewer.refresh();
                }
            }
        });
        gid = new GridData(4);
        gid.widthHint = 75;
        Button remove = new Button(myComposite, 8);
        remove.setText(Messages.getString("Preferences.Drivers.Button.Remove"));
        remove.setLayoutData((Object)gid);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel;
                ISQLDriver dv;
                boolean okToDelete = MessageDialog.openConfirm((Shell)DriverPreferencePage.this.getShell(), (String)Messages.getString("Preferences.Drivers.ConfirmDelete.Title"), (String)(String.valueOf(Messages.getString("Preferences.Drivers.ConfirmDelete.Prefix")) + DriverPreferencePage.this._tableViewer.getTable().getSelection()[0].getText() + Messages.getString("Preferences.Drivers.ConfirmDelete.Postfix")));
                if (okToDelete && (dv = (ISQLDriver)(sel = (StructuredSelection)DriverPreferencePage.this._tableViewer.getSelection()).getFirstElement()) != null) {
                    DriverPreferencePage.this._driverModel.removeDriver(dv);
                    DriverPreferencePage.this._tableViewer.refresh();
                    DriverPreferencePage.this.selectFirst();
                }
            }
        });
        gid = new GridData(4);
        gid.widthHint = 73;
        Button bdefault = new Button(myComposite, 8);
        bdefault.setText(Messages.getString("Preferences.Drivers.Button.Default"));
        bdefault.setLayoutData((Object)gid);
        bdefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < DriverPreferencePage.this._tableViewer.getTable().getItemCount()) {
                    DriverPreferencePage.this._tableViewer.getTable().getItem(i).setFont(0, table.getFont());
                    ++i;
                }
                DriverPreferencePage.this._boldfont = new Font((Device)DriverPreferencePage.this._tableViewer.getTable().getDisplay(), table.getFont().toString(), table.getFont().getFontData()[0].getHeight(), 1);
                DriverPreferencePage.this._tableViewer.getTable().getSelection()[0].setFont(0, DriverPreferencePage.this._boldfont);
                DriverPreferencePage.this._prefs.setValue("Drivers.DefaultDriverName", DriverPreferencePage.this._tableViewer.getTable().getSelection()[0].getText());
            }
        });
        Button bRestore = new Button(parent, 8);
        bRestore.setText(Messages.getString("Preferences.Drivers.Button.RestoreDefault"));
        bRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferencePage.this._driverModel.restoreDrivers();
                DriverPreferencePage.this._tableViewer.refresh();
                DriverPreferencePage.this.selectFirst();
            }
        });
        bRestore.setLayoutData((Object)new GridData(131072, 1024, false, false));
        this.selectDefault(table);
        return parent;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        return super.performOk();
    }

    private void changeDriver() {
        StructuredSelection sel = (StructuredSelection)this._tableViewer.getSelection();
        ISQLDriver dv = (ISQLDriver)sel.getFirstElement();
        if (dv != null) {
            CreateDriverDlg dlg = new CreateDriverDlg(this.getShell(), this._driverModel, 2, dv);
            dlg.open();
            this._tableViewer.refresh();
            this.selectFirst();
        }
    }

    void selectFirst() {
        if (this._driverModel.getElements().length > 0) {
            Object obj = this._driverModel.getElements()[0];
            StructuredSelection sel = new StructuredSelection(obj);
            this._tableViewer.setSelection((ISelection)sel);
        }
    }

    void selectDefault(Table table) {
        if (this._driverModel.getElements().length == 0) {
            return;
        }
        String defaultDriver = this._prefs.getString("Drivers.DefaultDriverName");
        if (defaultDriver == null) {
            return;
        }
        Object[] obj = this._driverModel.getElements();
        int i = 0;
        while (i < obj.length) {
            if (obj[i].toString().toLowerCase().startsWith(defaultDriver.toLowerCase())) {
                this._boldfont = new Font((Device)this._tableViewer.getTable().getDisplay(), table.getFont().toString(), table.getFont().getFontData()[0].getHeight(), 1);
                this._tableViewer.getTable().getItem(i).setFont(0, this._boldfont);
                this._tableViewer.getTable().pack(true);
                break;
            }
            ++i;
        }
    }
}

