/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.connections.ConnectionTreeActionGroup;
import net.sourceforge.sqlexplorer.connections.ConnectionTreeContentProvider;
import net.sourceforge.sqlexplorer.connections.ConnectionTreeLabelProvider;
import net.sourceforge.sqlexplorer.connections.actions.NewAliasAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.actions.OpenPasswordConnectDialogAction;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModelChangedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ConnectionsView
extends ViewPart
implements SessionTreeModelChangedListener {
    private AliasModel _aliasModel;
    private DriverModel _driverModel;
    private TreeViewer _treeViewer;

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "net.sourceforge.sqlexplorer.AliasView");
        SQLExplorerPlugin.getDefault().stm.addListener(this);
        this._driverModel = SQLExplorerPlugin.getDefault().getDriverModel();
        this._aliasModel = SQLExplorerPlugin.getDefault().getAliasModel();
        this._treeViewer = new TreeViewer(parent, 770);
        this.getSite().setSelectionProvider((ISelectionProvider)this._treeViewer);
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        NewAliasAction newAliasAction = new NewAliasAction();
        newAliasAction.setTreeViewer(this._treeViewer);
        newAliasAction.setView(this);
        toolBarMgr.add((IAction)newAliasAction);
        this._treeViewer.setUseHashlookup(true);
        this._treeViewer.setContentProvider((IContentProvider)new ConnectionTreeContentProvider());
        this._treeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionTreeLabelProvider());
        this._treeViewer.setInput((Object)this._aliasModel);
        this._treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && selection.getFirstElement() instanceof ISQLAlias) {
                    SQLAlias al = (SQLAlias)selection.getFirstElement();
                    OpenPasswordConnectDialogAction openDlgAction = new OpenPasswordConnectDialogAction(ConnectionsView.this.getSite(), al, ConnectionsView.this._driverModel, SQLExplorerPlugin.getDefault().getPreferenceStore(), SQLExplorerPlugin.getDefault().getSQLDriverManager());
                    openDlgAction.run();
                    ConnectionsView.this._treeViewer.refresh();
                }
            }
        });
        final ConnectionTreeActionGroup actionGroup = new ConnectionTreeActionGroup(this, this._treeViewer);
        MenuManager menuManager = new MenuManager("ConnectionTreeContextMenu");
        menuManager.setRemoveAllWhenShown(true);
        Menu contextMenu = menuManager.createContextMenu((Control)this._treeViewer.getTree());
        this._treeViewer.getTree().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                actionGroup.fillContextMenu(manager);
            }
        });
        parent.layout();
        SQLExplorerPlugin.getDefault().startDefaultConnections((IWorkbenchSite)this.getSite());
    }

    public void dispose() {
        SQLExplorerPlugin.getDefault().stm.removeListener(this);
        super.dispose();
    }

    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    public void modelChanged(SessionTreeNode newNode) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ConnectionsView.this._treeViewer.refresh();
            }
        });
    }

    public void setFocus() {
    }
}

