/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.actions;

import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.SQLDriverManager;
import net.sourceforge.sqlexplorer.connections.OpenConnectionJob;
import net.sourceforge.sqlexplorer.dialogs.PasswordConnDlg;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class OpenPasswordConnectDialogAction
extends Action {
    private Shell _shell;
    private ISQLAlias _alias;
    private DriverModel _driverModel;
    private IPreferenceStore _store;
    private SQLDriverManager _dmgr;
    private IWorkbenchPartSite _site;
    static /* synthetic */ Class class$0;

    public OpenPasswordConnectDialogAction(IWorkbenchPartSite site, ISQLAlias alias, DriverModel model, IPreferenceStore store, SQLDriverManager dmgr) {
        this._site = site;
        this._shell = site.getShell();
        this._alias = alias;
        this._driverModel = model;
        this._store = store;
        this._dmgr = dmgr;
    }

    public void run() {
        String user = this._alias.getUserName();
        String pswd = this._alias.getPassword();
        boolean autoCommit = SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.AutoCommit");
        boolean commitOnClose = SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.CommitOnClose");
        if (!this._alias.isAutoLogon()) {
            PasswordConnDlg dlg = new PasswordConnDlg(this._shell, this._alias, this._driverModel, this._store);
            if (dlg.open() == 0) {
                pswd = dlg.getPassword();
                user = dlg.getUser();
                autoCommit = dlg.getAutoCommit();
                commitOnClose = dlg.getCommitOnClose();
            } else {
                return;
            }
        }
        ISQLDriver dv = this._driverModel.getDriver(this._alias.getDriverIdentifier());
        OpenConnectionJob bgJob = new OpenConnectionJob(this._dmgr, dv, this._alias, user, pswd, autoCommit, commitOnClose, this._shell);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchSiteProgressService siteps = (IWorkbenchSiteProgressService)this._site.getAdapter((Class)clazz);
        siteps.showInDialog(this._shell, (Job)bgJob);
        bgJob.schedule();
    }
}

