/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DataCache;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.SQLDriverManager;
import net.sourceforge.sqlexplorer.connections.OpenConnectionJob;
import net.sourceforge.sqlexplorer.history.SQLHistory;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.osgi.framework.BundleContext;

public class SQLExplorerPlugin
extends AbstractUIPlugin {
    private DataCache _cache;
    private SQLDriverManager _driverMgr;
    private AliasModel aliasModel;
    private int count = 0;
    private DriverModel driverModel;
    private ResourceBundle resourceBundle;
    public SessionTreeModel stm = new SessionTreeModel();
    private SQLHistory _history = null;
    private static final Log _logger;
    private static SQLExplorerPlugin plugin;
    public static final String PLUGIN_ID = "net.sourceforge.sqlexplorer";
    private boolean _defaultConnectionsStarted = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = LogFactory.getLog((Class)clazz);
    }

    public SQLExplorerPlugin() {
        plugin = this;
    }

    public AliasModel getAliasModel() {
        return this.aliasModel;
    }

    public DriverModel getDriverModel() {
        return this.driverModel;
    }

    public int getNextElement() {
        return this.count++;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public SQLDriverManager getSQLDriverManager() {
        if (this._driverMgr == null) {
            this._driverMgr = new SQLDriverManager();
        }
        return this._driverMgr;
    }

    public SQLHistory getSQLHistory() {
        return this._history;
    }

    public String getVersion() {
        String version = (String)plugin.getBundle().getHeaders().get("Bundle-Version");
        return version;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this._driverMgr = new SQLDriverManager();
        this._cache = new DataCache(this._driverMgr);
        this.aliasModel = new AliasModel(this._cache);
        this.driverModel = new DriverModel(this._cache);
        try {
            this.resourceBundle = ResourceBundle.getBundle("net.sourceforge.sqlexplorer.test");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this._history = new SQLHistory();
    }

    public void startDefaultConnections(IWorkbenchSite site) {
        if (this._defaultConnectionsStarted) {
            return;
        }
        boolean autoCommit = SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.AutoCommit");
        boolean commitOnClose = SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.CommitOnClose");
        Object[] aliases = this.aliasModel.getElements();
        int i = 0;
        while (i < aliases.length) {
            ISQLAlias alias = (ISQLAlias)aliases[i];
            if (alias.isConnectAtStartup() && alias.isAutoLogon()) {
                try {
                    ISQLDriver dv = this.driverModel.getDriver(alias.getDriverIdentifier());
                    OpenConnectionJob bgJob = new OpenConnectionJob(this._driverMgr, dv, alias, alias.getUserName(), alias.getPassword(), autoCommit, commitOnClose, site.getShell());
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IWorkbenchSiteProgressService siteps = (IWorkbenchSiteProgressService)site.getAdapter((Class)clazz);
                    siteps.showInDialog(site.getShell(), (Job)bgJob);
                    bgJob.schedule();
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error creating sql connection to " + alias.getName(), e);
                }
            }
            ++i;
        }
        this._defaultConnectionsStarted = true;
    }

    public void stop(BundleContext context) throws Exception {
        this._cache.save();
        RootSessionTreeNode rstn = this.stm.getRoot();
        rstn.closeAllConnections();
        this._history.save();
        super.stop(context);
    }

    public static void error(String message, Throwable t) {
        SQLExplorerPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, String.valueOf(message), t));
        _logger.error((Object)message, t);
    }

    public static SQLExplorerPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SQLExplorerPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }
}

