/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.history;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.TextUtil;

public class SQLHistoryElement {
    private int _executionCount = 1;
    private String _formattedTime;
    private String _rawSQLString;
    private String _searchableString;
    private String _sessionName;
    private String _singleLineText;
    private long _time;
    private static SimpleDateFormat _dateFormatter = new SimpleDateFormat(SQLExplorerPlugin.getDefault().getPluginPreferences().getString("DataSetResult.DateFormat"));

    public SQLHistoryElement(String rawSQLString, String sessionName) {
        this._rawSQLString = rawSQLString;
        this._sessionName = sessionName;
        this._time = System.currentTimeMillis();
        this.intialize();
    }

    public SQLHistoryElement(String rawSQLString, String sessionName, String time, String executions) {
        this._rawSQLString = rawSQLString;
        this._sessionName = sessionName;
        this._time = time != null && time.length() != 0 ? Long.parseLong(time) : System.currentTimeMillis();
        this._executionCount = executions != null && executions.length() != 0 ? Integer.parseInt(executions) : 1;
        this.intialize();
    }

    public boolean equals(String rawSQL) {
        return TextUtil.removeLineBreaks(rawSQL).equals(this._singleLineText);
    }

    public int getExecutionCount() {
        return this._executionCount;
    }

    public String getFormattedTime() {
        return this._formattedTime;
    }

    public String getRawSQLString() {
        return this._rawSQLString;
    }

    public String getSearchableString() {
        return this._searchableString;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public String getSingleLineText() {
        return this._singleLineText;
    }

    public long getTime() {
        return this._time;
    }

    public void increaseExecutionCount() {
        ++this._executionCount;
        this._time = System.currentTimeMillis();
        this.intialize();
    }

    private void intialize() {
        this._formattedTime = _dateFormatter.format(new Date(this._time));
        this._searchableString = (String.valueOf(this._rawSQLString) + " " + this._sessionName + " " + this._formattedTime).toLowerCase();
        this._singleLineText = TextUtil.removeLineBreaks(this._rawSQLString);
    }

    public void setSessionName(String sessionName) {
        this._sessionName = sessionName;
        this.intialize();
    }
}

