/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.dialogs.CreateDriverDlg;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateAliasDlg
extends TitleAreaDialog {
    Button _btnAutoLogon;
    private SQLAlias alias;
    private AliasModel aliasModel;
    Button btnActivate;
    Combo combo;
    DriverModel driverModel;
    Text nameField;
    Text passwordField;
    int type;
    Text urlField;
    Text userField;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public CreateAliasDlg(Shell parentShell, DriverModel dm, int type, SQLAlias al, AliasModel am) {
        super(parentShell);
        this.driverModel = dm;
        this.alias = al;
        this.aliasModel = am;
        this.type = type;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.type == 1) {
            shell.setText(Messages.getString("AliasDialog.Create.Title"));
        } else if (this.type == 2) {
            shell.setText(Messages.getString("AliasDialog.Change.Title"));
        } else if (this.type == 3) {
            shell.setText(Messages.getString("AliasDialog.Copy.Title"));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.type == 1) {
            this.setTitle(Messages.getString("AliasDialog.Create.Title"));
            this.setMessage("Create a new alias");
        } else if (this.type == 2) {
            this.setTitle(Messages.getString("AliasDialog.Change.Title"));
            this.setMessage("Modify the alias");
        } else if (this.type == 3) {
            this.setTitle(Messages.getString("AliasDialog.Copy.Title"));
            this.setMessage("Copy the alias");
        }
        Image image = ImageUtil.getImage("Images.WizardLogo");
        if (image != null) {
            this.setTitleImage(image);
        }
        contents.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageUtil.disposeImage("Images.WizardLogo");
            }
        });
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        nameGroup.setLayoutData((Object)data);
        Label label = new Label(nameGroup, 64);
        label.setText("Name");
        this.nameField = new Text(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.nameField.setLayoutData((Object)data);
        this.nameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CreateAliasDlg.this.validate();
            }

            public void keyReleased(KeyEvent e) {
                CreateAliasDlg.this.validate();
            }
        });
        Label label2 = new Label(nameGroup, 64);
        label2.setText("Driver");
        this.combo = new Combo(nameGroup, 2060);
        data = new GridData(768);
        data.widthHint = 250;
        int size = this.driverModel.size();
        String defaultDriverName = SQLExplorerPlugin.getDefault().getPluginPreferences().getString("Drivers.DefaultDriverName");
        int defaultDriver = 0;
        int i = 0;
        while (i < size) {
            String driverName = this.driverModel.getElement(i).toString();
            if (driverName.startsWith(defaultDriverName)) {
                defaultDriver = i;
            }
            this.combo.add(driverName);
            ++i;
        }
        this.combo.setLayoutData((Object)data);
        Button button = new Button(nameGroup, 0);
        button.setText(Messages.getString("New_Driver..._9"));
        data = new GridData(768);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IdentifierFactory factory = IdentifierFactory.getInstance();
                ISQLDriver driver = CreateAliasDlg.this.driverModel.createDriver(factory.createIdentifier());
                CreateDriverDlg dlg = new CreateDriverDlg(CreateAliasDlg.this.getShell(), CreateAliasDlg.this.driverModel, 1, driver);
                dlg.open();
                CreateAliasDlg.this.combo.removeAll();
                int size = CreateAliasDlg.this.driverModel.size();
                int i = 0;
                while (i < size) {
                    CreateAliasDlg.this.combo.add(CreateAliasDlg.this.driverModel.getElement(i).toString());
                    ++i;
                }
            }
        });
        Label label3 = new Label(nameGroup, 64);
        label3.setText("URL");
        this.urlField = new Text(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.urlField.setLayoutData((Object)data);
        this.urlField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CreateAliasDlg.this.validate();
            }

            public void keyReleased(KeyEvent e) {
                CreateAliasDlg.this.validate();
            }
        });
        Label label4 = new Label(nameGroup, 64);
        label4.setText("User Name");
        this.userField = new Text(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.userField.setLayoutData((Object)data);
        this.userField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CreateAliasDlg.this.validate();
            }

            public void keyReleased(KeyEvent e) {
                CreateAliasDlg.this.validate();
            }
        });
        Label label5 = new Label(nameGroup, 64);
        label5.setText("Password");
        this.passwordField = new Text(nameGroup, 2048);
        this.passwordField.setEchoChar('*');
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.passwordField.setLayoutData((Object)data);
        Label label8 = new Label(nameGroup, 64);
        label8.setText(Messages.getString("AliasDialog.AutoLogon"));
        label8.setToolTipText(Messages.getString("AliasDialog.AutoLogonToolTip"));
        this._btnAutoLogon = new Button(nameGroup, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this._btnAutoLogon.setLayoutData((Object)data);
        Label label7 = new Label(nameGroup, 64);
        label7.setText("Open on Startup");
        this.btnActivate = new Button(nameGroup, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.btnActivate.setLayoutData((Object)data);
        this._btnAutoLogon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean active = ((Button)event.widget).getSelection();
                CreateAliasDlg.this.btnActivate.setEnabled(active);
                if (!active) {
                    CreateAliasDlg.this.btnActivate.setSelection(false);
                }
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int selIndex = CreateAliasDlg.this.combo.getSelectionIndex();
                CreateAliasDlg.this.urlField.setText(CreateAliasDlg.this.driverModel.getElement(selIndex).getUrl());
                CreateAliasDlg.this.validate();
            }
        });
        if (size > 0) {
            this.combo.select(defaultDriver);
            this.urlField.setText(this.driverModel.getElement(defaultDriver).getUrl());
        }
        this.loadData();
        return parentComposite;
    }

    private void loadData() {
        this.nameField.setText(this.alias.getName());
        this.userField.setText(this.alias.getUserName());
        this.passwordField.setText(this.alias.getPassword());
        this._btnAutoLogon.setSelection(this.alias.isAutoLogon());
        if (!this.alias.isAutoLogon()) {
            this.btnActivate.setEnabled(false);
            this.btnActivate.setSelection(false);
        } else {
            this.btnActivate.setSelection(this.alias.isConnectAtStartup());
        }
        if (this.type != 1) {
            ISQLDriver iSqlDriver = this.driverModel.getDriver(this.alias.getDriverIdentifier());
            this.combo.setText(iSqlDriver.getName());
            this.urlField.setText(this.alias.getUrl());
        }
    }

    protected void okPressed() {
        try {
            this.alias.setName(this.nameField.getText().trim());
            int selIndex = this.combo.getSelectionIndex();
            this.alias.setDriverIdentifier(this.driverModel.getElement(selIndex).getIdentifier());
            this.alias.setUrl(this.urlField.getText().trim());
            this.alias.setUserName(this.userField.getText().trim());
            this.alias.setName(this.nameField.getText().trim());
            this.alias.setSchemaFilterExpression("");
            this.alias.setNameFilterExpression("");
            this.alias.setFolderFilterExpression("");
            this.alias.setConnectAtStartup(this.btnActivate.getSelection());
            this.alias.setPassword(this.passwordField.getText().trim());
            this.alias.setAutoLogon(this._btnAutoLogon.getSelection());
            if (this.type == 1 || this.type == 3) {
                this.aliasModel.addAlias(this.alias);
            }
        }
        catch (ValidationException excp) {
            SQLExplorerPlugin.error("Validation Exception", excp);
        }
        catch (DuplicateObjectException excp1) {
            SQLExplorerPlugin.error("Duplicate Exception", excp1);
        }
        this.close();
    }

    protected void setDialogComplete(boolean value) {
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setEnabled(value);
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    void validate() {
        if (this.urlField.getText().trim().length() > 0 && this.nameField.getText().trim().length() > 0) {
            this.setDialogComplete(true);
        } else {
            this.setDialogComplete(false);
        }
    }
}

