/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import java.net.URL;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

class AboutItem {
    Image logoImage = ImageUtil.getImage("Images.Logo");

    AboutItem(TabItem item, Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ImageUtil.disposeImage("Images.Logo");
            }
        });
        Composite cmp = new Composite(parent, 0);
        item.setControl((Control)cmp);
        GridLayout lay = new GridLayout();
        lay.numColumns = 1;
        lay.marginWidth = 15;
        lay.marginHeight = 15;
        cmp.setLayout((Layout)lay);
        Label lb = new Label(cmp, 0);
        lb.setText(Messages.getString("AboutDialog.About.copyright"));
        GridData data = new GridData(6);
        lb.setLayoutData((Object)data);
        lb.setSize(-1, 50);
        ImageData imgData = this.logoImage.getImageData();
        int width = imgData.width;
        int height = imgData.height;
        Composite imgComposite = new Composite(cmp, 2048);
        data = new GridData(6);
        imgComposite.setLayoutData((Object)data);
        data.heightHint = height;
        data.widthHint = width;
        final Color imageBackgroundColor = new Color((Device)parent.getDisplay(), 255, 255, 255);
        final Color fontColor = new Color((Device)parent.getDisplay(), 102, 118, 145);
        final String version = String.valueOf(Messages.getString("AboutDialog.About.versionPrefix")) + SQLExplorerPlugin.getDefault().getVersion();
        imgComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                gc.drawImage(AboutItem.this.logoImage, 0, 0);
                gc.setBackground(imageBackgroundColor);
                gc.setForeground(fontColor);
                gc.drawText(version, 290, 75);
            }
        });
        Link link = new Link(cmp, 0x1000000);
        link.setText(Messages.getString("AboutDialog.About.url"));
        data = new GridData(4);
        link.setLayoutData((Object)data);
        link.setForeground(fontColor);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    IWebBrowser browser = WorkbenchBrowserSupport.getInstance().getExternalBrowser();
                    browser.openURL(new URL(event.text));
                }
                catch (Exception e) {
                    SQLExplorerPlugin.error("Error launching browser", e);
                }
            }
        });
    }
}

