/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableFolderNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.sqlexplorer.util.TextUtil;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SchemaNode
extends AbstractNode {
    private List _childNames = new ArrayList();
    private String[] _filteredNames;
    private static final Log _logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.dbstructure.nodes.SchemaNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = LogFactory.getLog((Class)clazz);
    }

    public SchemaNode(INode parent, String name, SessionTreeNode sessionNode) {
        this._sessionNode = sessionNode;
        this._parent = parent;
        this._name = name;
        this._imageKey = "Images.SchemaNodeIcon";
    }

    private void addExtensionNodes() {
        String databaseProductName = this.getSession().getRoot().getDatabaseProductName().toLowerCase().trim();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "node");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension e = extensions[i];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    String parent = ces[j].getAttribute("parent-node");
                    if (parent.indexOf("schema") != -1) {
                        boolean isValidProduct = false;
                        String[] validProducts = ces[j].getAttribute("database-product-name").split(",");
                        int k = 0;
                        while (k < validProducts.length) {
                            String product = validProducts[k].toLowerCase().trim();
                            if (product.length() != 0) {
                                if (product.equals("*")) {
                                    isValidProduct = true;
                                    break;
                                }
                                String regex = TextUtil.replaceChar(product, '*', ".*");
                                if (databaseProductName.matches(regex)) {
                                    isValidProduct = true;
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (isValidProduct) {
                            String imagePath = ces[j].getAttribute("icon");
                            String id = ces[j].getAttribute("id");
                            String type = ces[j].getAttribute("table-type").trim();
                            AbstractNode childNode = (AbstractNode)ces[j].createExecutableExtension("class");
                            childNode.setParent(this);
                            childNode.setSession(this._sessionNode);
                            childNode.setType(type);
                            String fragmentId = id.substring(0, id.indexOf(46, 28));
                            if (imagePath != null && imagePath.trim().length() != 0) {
                                childNode.setImage(ImageUtil.getFragmentImage(fragmentId, imagePath));
                            }
                            this._childNames.add(childNode.getLabelText());
                            if (!this.isExcludedByFilter(childNode.getLabelText())) {
                                this.addChildNode(childNode);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create child node", ex);
                }
                ++j;
            }
            ++i;
        }
    }

    private INode findExtensionNode(String tableType) {
        String databaseProductName = this.getSession().getRoot().getDatabaseProductName().toLowerCase().trim();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "node");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension e = extensions[i];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    String parent = ces[j].getAttribute("parent-node");
                    if (parent.indexOf("schema") != -1) {
                        String type;
                        boolean isValidProduct = false;
                        String[] validProducts = ces[j].getAttribute("database-product-name").split(",");
                        int k = 0;
                        while (k < validProducts.length) {
                            String product = validProducts[k].toLowerCase().trim();
                            if (product.length() != 0) {
                                if (product.equals("*")) {
                                    isValidProduct = true;
                                    break;
                                }
                                String regex = TextUtil.replaceChar(product, '*', ".*");
                                if (databaseProductName.matches(regex)) {
                                    isValidProduct = true;
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (isValidProduct && (type = ces[j].getAttribute("table-type").trim()).equalsIgnoreCase(tableType)) {
                            AbstractNode childNode = (AbstractNode)ces[j].createExecutableExtension("class");
                            childNode.setParent(this);
                            childNode.setSession(this._sessionNode);
                            return childNode;
                        }
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create child node", ex);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public String[] getChildNames() {
        if (this._childNames.size() == 0) {
            this.getChildNodes();
        }
        return this._childNames.toArray(new String[0]);
    }

    public String getType() {
        return "schema";
    }

    public String getUniqueIdentifier() {
        return this.getQualifiedName();
    }

    protected boolean isExcludedByFilter(String name) {
        String filter;
        if (this._filteredNames == null && (filter = ((SQLAlias)this.getSession().getAlias()).getFolderFilterExpression()) != null) {
            this._filteredNames = filter.split(",");
        }
        if (this._filteredNames == null || this._filteredNames.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this._filteredNames.length) {
            if (this._filteredNames[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void loadChildren() {
        this._childNames = new ArrayList();
        try {
            ITableInfo[] tables = null;
            String[] tableTypes = this._sessionNode.getMetaData().getTableTypes();
            try {
                tables = this._sessionNode.getMetaData().getTables(this._name, this._name, "%", tableTypes);
            }
            catch (Throwable throwable) {
                _logger.debug((Object)"Loading all tables at once is not supported");
            }
            int i = 0;
            while (i < tableTypes.length) {
                INode childNode = this.findExtensionNode(tableTypes[i]);
                if (childNode != null) {
                    this._childNames.add(childNode.getLabelText());
                    if (!this.isExcludedByFilter(childNode.getLabelText())) {
                        this.addChildNode(childNode);
                    }
                } else {
                    TableFolderNode node = new TableFolderNode(this, tableTypes[i], this._sessionNode, tables);
                    this._childNames.add(node.getLabelText());
                    if (!this.isExcludedByFilter(node.getLabelText())) {
                        this.addChildNode(node);
                    }
                }
                ++i;
            }
            this.addExtensionNodes();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Could not load child nodes for " + this._name, e);
        }
    }
}

