/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import java.sql.ResultSet;
import java.util.Comparator;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.ColumnNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;

public class IndexNode
extends AbstractNode {
    private TableNode _parentTable;

    public IndexNode(INode node, String name, SessionTreeNode session, TableNode parentTable) throws Exception {
        this._parentTable = parentTable;
        this._parent = node;
        this._sessionNode = session;
        this._name = name;
        this._imageKey = "Images.IndexIcon";
    }

    public Comparator getComparator() {
        return null;
    }

    public String getQualifiedName() {
        return String.valueOf(this._parent.getParent().getName()) + "." + this._name;
    }

    public String getType() {
        return "index";
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this._parent.getParent().getQualifiedName()) + "." + this._name;
    }

    public void loadChildren() {
        try {
            ResultSet resultSet = this._sessionNode.getMetaData().getIndexInfo(this._parentTable.getTableInfo());
            while (resultSet.next()) {
                String indexName = resultSet.getString(6);
                String columnName = resultSet.getString(9);
                String sort = resultSet.getString(10);
                if (indexName == null || !indexName.equalsIgnoreCase(this._name)) continue;
                ColumnNode col = new ColumnNode(this, columnName, this._sessionNode, this._parentTable, true);
                if (sort == null || sort.equalsIgnoreCase("A")) {
                    col.setLabelDecoration("ASC");
                } else {
                    col.setLabelDecoration("DESC");
                }
                this.addChildNode(col);
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Could not load column names", e);
        }
    }
}

