/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractFolderNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.IndexNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;

public class IndexFolderNode
extends AbstractFolderNode {
    private ITableInfo _tableInfo;

    public IndexFolderNode(INode parent, ITableInfo tableInfo) {
        this._tableInfo = tableInfo;
        this._sessionNode = parent.getSession();
        this._parent = parent;
        this._name = Messages.getString("DatabaseStructureView.node.Indexes");
    }

    public List getIndexNames() {
        ArrayList<String> indexNames = new ArrayList<String>();
        try {
            ResultSet resultSet = this._sessionNode.getMetaData().getIndexInfo(this._tableInfo);
            while (resultSet.next()) {
                String name = resultSet.getString(6);
                if (name == null || indexNames.contains(name)) continue;
                indexNames.add(name);
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Could not load index names", e);
        }
        return indexNames;
    }

    public String getName() {
        return this._name;
    }

    public String getQualifiedName() {
        return String.valueOf(this.getParent().getQualifiedName()) + "." + this.getType();
    }

    public String getType() {
        return "index_folder";
    }

    public void loadChildren() {
        try {
            Iterator it = this.getIndexNames().iterator();
            while (it.hasNext()) {
                this.addChildNode(new IndexNode(this, (String)it.next(), this._sessionNode, (TableNode)this.getParent()));
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Could not create child nodes for " + this.getName(), e);
        }
    }
}

