/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.CatalogNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.SchemaNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.TextUtil;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DatabaseNode
extends AbstractNode {
    private SQLAlias _alias;
    private List _childNames = new ArrayList();
    private String _databaseProductName = "";
    private String[] _filterExpressions;
    private boolean _supportsCatalogs = false;
    private boolean _supportsSchemas = false;
    private String _databaseVersion = "";

    public DatabaseNode(String name, SessionTreeNode session) {
        this._name = name;
        this._sessionNode = session;
        this._alias = (SQLAlias)this._sessionNode.getAlias();
        this._imageKey = "Images.DatabaseIcon";
        SQLDatabaseMetaData metadata = this._sessionNode.getMetaData();
        try {
            if (metadata.supportsCatalogs()) {
                this._supportsCatalogs = true;
            }
            if (metadata.supportsSchemas()) {
                this._supportsSchemas = true;
            }
            this._databaseProductName = metadata.getDatabaseProductName();
            this._databaseVersion = " [v" + metadata.getJDBCMetaData().getDatabaseMajorVersion() + "." + metadata.getJDBCMetaData().getDatabaseMinorVersion() + "]";
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error loading database product name.", e);
        }
        catch (AbstractMethodError e) {
            SQLExplorerPlugin.error("Error loading database product name.", e);
        }
    }

    public List getCatalogs() {
        ArrayList catalogs = new ArrayList();
        Iterator it = this.getChildIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof CatalogNode)) continue;
            catalogs.add(o);
        }
        return catalogs;
    }

    public String[] getChildNames() {
        if (this._childNames.size() == 0) {
            this.getChildNodes();
        }
        return this._childNames.toArray(new String[0]);
    }

    public String getDatabaseProductName() {
        return this._databaseProductName;
    }

    public String getLabelText() {
        if (this._alias.isFiltered()) {
            return String.valueOf(this._databaseProductName) + " " + this._databaseVersion + " " + Messages.getString("DatabaseStructureView.filteredPostfix");
        }
        return String.valueOf(this._databaseProductName) + " " + this._databaseVersion;
    }

    public List getSchemas() {
        ArrayList schemas = new ArrayList();
        Iterator it = this.getChildIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof SchemaNode)) continue;
            schemas.add(o);
        }
        return schemas;
    }

    public String getType() {
        return "database";
    }

    public String getUniqueIdentifier() {
        return this.getQualifiedName();
    }

    private boolean isExcludedByFilter(String name) {
        if (this._filterExpressions == null || this._filterExpressions.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this._filterExpressions.length) {
            String regex = this._filterExpressions[i].trim();
            regex = TextUtil.replaceChar(regex, '?', ".");
            if ((regex = TextUtil.replaceChar(regex, '*', ".*")).length() != 0 && name.matches(regex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void loadChildren() {
        this._childNames = new ArrayList();
        String metaFilterExpression = this._alias.getSchemaFilterExpression();
        this._filterExpressions = metaFilterExpression != null && metaFilterExpression.trim().length() != 0 ? metaFilterExpression.split(",") : null;
        SQLDatabaseMetaData metadata = this._sessionNode.getMetaData();
        try {
            int i;
            if (this._supportsCatalogs) {
                String[] catalogs = metadata.getCatalogs();
                i = 0;
                while (i < catalogs.length) {
                    this._childNames.add(catalogs[i]);
                    if (!this.isExcludedByFilter(catalogs[i])) {
                        this.addChildNode(new CatalogNode(this, catalogs[i], this._sessionNode));
                    }
                    ++i;
                }
            } else if (this._supportsSchemas) {
                String[] schemas = metadata.getSchemas();
                i = 0;
                while (i < schemas.length) {
                    this._childNames.add(schemas[i]);
                    if (!this.isExcludedByFilter(schemas[i])) {
                        this.addChildNode(new SchemaNode(this, schemas[i], this._sessionNode));
                    }
                    ++i;
                }
            } else {
                this.addChildNode(new CatalogNode(this, Messages.getString("NoCatalog_2"), this._sessionNode));
            }
            String databaseProductName = this._databaseProductName.toLowerCase().trim();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "node");
            IExtension[] extensions = point.getExtensions();
            int i2 = 0;
            while (i2 < extensions.length) {
                IExtension e = extensions[i2];
                IConfigurationElement[] ces = e.getConfigurationElements();
                int j = 0;
                while (j < ces.length) {
                    try {
                        String parent = ces[j].getAttribute("parent-node");
                        if (parent.equalsIgnoreCase("root")) {
                            boolean isValidProduct = false;
                            String[] validProducts = ces[j].getAttribute("database-product-name").split(",");
                            int k = 0;
                            while (k < validProducts.length) {
                                String product = validProducts[k].toLowerCase().trim();
                                if (product.length() != 0) {
                                    if (product.equals("*")) {
                                        isValidProduct = true;
                                        break;
                                    }
                                    String regex = TextUtil.replaceChar(product, '*', ".*");
                                    if (databaseProductName.matches(regex)) {
                                        isValidProduct = true;
                                        break;
                                    }
                                }
                                ++k;
                            }
                            if (isValidProduct) {
                                String type = ces[j].getAttribute("table-type").trim();
                                AbstractNode childNode = (AbstractNode)ces[j].createExecutableExtension("class");
                                childNode.setParent(this);
                                childNode.setSession(this._sessionNode);
                                childNode.setType(type);
                                this.addChildNode(childNode);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        SQLExplorerPlugin.error("Could not create child node", ex);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error loading children", e);
        }
    }

    public boolean supportsCatalogs() {
        return this._supportsCatalogs;
    }

    public boolean supportsSchemas() {
        return this._supportsSchemas;
    }
}

