/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;

public class ColumnNode
extends AbstractNode {
    private boolean _isForeignKey = false;
    private boolean _isPrimaryKey = false;
    private String _labelDecoration = null;
    private TableNode _parentTable;

    public ColumnNode(INode node, String name, SessionTreeNode session, TableNode parentTable, boolean showKeyLabels) throws Exception {
        this._parent = node;
        this._parentTable = parentTable;
        this._sessionNode = session;
        this._name = name;
        this._imageKey = "Images.ColumnNodeIcon";
        if (showKeyLabels && this._parentTable.getPrimaryKeyNames().contains(this._name)) {
            this._isPrimaryKey = true;
            this._imageKey = "Images.PrimaryKeyIcon";
        }
    }

    public String getLabelDecoration() {
        return this._labelDecoration;
    }

    public String getQualifiedParentTableName() {
        return this._parentTable.getQualifiedName();
    }

    public String getQualifiedName() {
        return String.valueOf(this._parentTable.getName()) + "." + this._name;
    }

    public String getType() {
        return "column";
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this._parentTable.getQualifiedName()) + "." + this._name;
    }

    public boolean isEndNode() {
        return true;
    }

    public boolean isForeignKey() {
        return this._isForeignKey;
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    public void loadChildren() {
    }

    public void setLabelDecoration(String text) {
        this._labelDecoration = text;
    }
}

