/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractNode
implements INode {
    protected ArrayList _children = new ArrayList();
    private boolean _childrenLoaded = false;
    protected String _expandedImageKey = null;
    protected Image _image;
    protected String _imageKey = "Images.DefaultNodeImage";
    private boolean _isExpanded = false;
    protected String _name;
    protected INode _parent;
    protected SessionTreeNode _sessionNode;
    protected String _type;
    private static final Log _logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = LogFactory.getLog((Class)clazz);
    }

    public final void addChildNode(INode childNode) {
        this._children.add(childNode);
    }

    public void fillDetailComposite(Composite composite) {
    }

    public final Iterator getChildIterator() {
        if (!this._childrenLoaded) {
            this.load();
        }
        return this._children.iterator();
    }

    public final INode[] getChildNodes() {
        if (!this._childrenLoaded) {
            this.load();
            Comparator comp = this.getComparator();
            if (comp != null) {
                Collections.sort(this._children, this.getComparator());
            }
        }
        if (this._children.size() == 0) {
            return null;
        }
        return this._children.toArray(new INode[0]);
    }

    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null || arg1 == null) {
                    return 0;
                }
                String name0 = ((INode)arg0).getName();
                String name1 = ((INode)arg1).getName();
                if (name0 == null || name1 == null) {
                    return 0;
                }
                return name0.compareTo(name1);
            }
        };
    }

    public final Image getExpandedImage() {
        if (this._expandedImageKey == null) {
            return null;
        }
        return ImageUtil.getImage(this._expandedImageKey);
    }

    public Image getImage() {
        if (this._image != null) {
            return this._image;
        }
        if (this._imageKey == null) {
            return this._image;
        }
        return ImageUtil.getImage(this._imageKey);
    }

    public String getLabelDecoration() {
        return null;
    }

    public String getLabelText() {
        return this.getName();
    }

    public String getName() {
        if (this._name == null) {
            return "<null>";
        }
        return this._name;
    }

    public final INode getParent() {
        return this._parent;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getSchemaOrCatalogName() {
        INode node = this;
        while (!node.getType().equalsIgnoreCase("schema") && !node.getType().equalsIgnoreCase("catalog")) {
            if ((node = node.getParent()) != null) continue;
            return null;
        }
        return node.getName();
    }

    public final SessionTreeNode getSession() {
        return this._sessionNode;
    }

    public String getType() {
        return this._type;
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this.getParent().getQualifiedName()) + "." + this.getQualifiedName();
    }

    public final boolean hasChildNodes() {
        if (!this._childrenLoaded && !this.isEndNode()) {
            return true;
        }
        return this._children != null && this._children.size() != 0;
    }

    public void initialize(INode parent, String name, SessionTreeNode sessionNode) {
        this._parent = parent;
        this._name = name;
        this._sessionNode = sessionNode;
    }

    public boolean isEndNode() {
        return false;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public final void load() {
        if (!this._childrenLoaded) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Loading child nodes for " + this._name));
                }
                this.loadChildren();
                this._childrenLoaded = true;
            }
            catch (AbstractMethodError e) {
                SQLExplorerPlugin.error("Could not load child nodes for " + this._name, e);
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Could not load child nodes for " + this._name, e);
            }
        }
    }

    public abstract void loadChildren();

    public final void refresh() {
        this._children.clear();
        this._childrenLoaded = false;
        this.load();
    }

    public final void setExpanded(boolean expanded) {
        this._isExpanded = expanded;
    }

    public void setImage(Image image) {
        this._image = image;
    }

    public final void setParent(INode parent) {
        this._parent = parent;
    }

    public final void setSession(SessionTreeNode session) {
        this._sessionNode = session;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String toString() {
        return this.getName();
    }
}

