/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbdetail.DetailTabManager;
import net.sourceforge.sqlexplorer.dbstructure.actions.AbstractDBTreeContextAction;
import net.sourceforge.sqlexplorer.dbstructure.nodes.DatabaseNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.resource.ImageDescriptor;

public class RefreshNodeAction
extends AbstractDBTreeContextAction {
    private static final ImageDescriptor _image = ImageUtil.getDescriptor("Images.RefreshIcon");

    public ImageDescriptor getImageDescriptor() {
        return _image;
    }

    public String getText() {
        return Messages.getString("DatabaseStructureView.Actions.Refresh");
    }

    public void run() {
        int i = 0;
        while (i < this._selectedNodes.length) {
            if (this._selectedNodes[i] instanceof DatabaseNode) {
                DetailTabManager.clearCacheForSession(this._selectedNodes[i].getSession());
                break;
            }
            DetailTabManager.clearCacheForNode(this._selectedNodes[i]);
            ++i;
        }
        i = 0;
        while (i < this._selectedNodes.length) {
            this._selectedNodes[i].refresh();
            ++i;
        }
        DatabaseStructureView structureView = (DatabaseStructureView)SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView");
        this._treeViewer.refresh();
        DatabaseDetailView detailView = (DatabaseDetailView)SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
        structureView.synchronizeDetailView(detailView);
    }

    public boolean isAvailable() {
        return this._selectedNodes.length != 0;
    }
}

