/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.actions;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.actions.AbstractDBTreeContextAction;
import net.sourceforge.sqlexplorer.dbstructure.nodes.ColumnNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class GenerateSelectSQLAction
extends AbstractDBTreeContextAction {
    private static final ImageDescriptor _image = ImageUtil.getDescriptor("Images.SqlEditorIcon");

    private String createColumnSelect() {
        StringBuffer query = new StringBuffer("select ");
        String sep = "";
        String table = "";
        int i = 0;
        while (i < this._selectedNodes.length) {
            INode node = this._selectedNodes[i];
            if (node instanceof ColumnNode) {
                ColumnNode column = (ColumnNode)node;
                if (table.length() == 0) {
                    table = column.getQualifiedParentTableName();
                }
                if (column.getQualifiedParentTableName().equals(table)) {
                    query.append(sep);
                    query.append(column.getName());
                    sep = ", ";
                }
            }
            ++i;
        }
        query.append(" from ");
        query.append(table);
        return query.toString();
    }

    private String createTableSelect() {
        TableNode node = (TableNode)this._selectedNodes[0];
        StringBuffer query = new StringBuffer("select ");
        String sep = "";
        List columnNames = node.getColumnNames();
        Iterator it = columnNames.iterator();
        while (it.hasNext()) {
            query.append(sep);
            String column = (String)it.next();
            query.append(column);
            sep = ", ";
        }
        query.append(" from ");
        query.append(node.getQualifiedName());
        return query.toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return _image;
    }

    public String getText() {
        return Messages.getString("DatabaseStructureView.Actions.GenerateSelectSQL");
    }

    public boolean isAvailable() {
        if (this._selectedNodes.length == 0) {
            return false;
        }
        if (this._selectedNodes[0] instanceof ColumnNode) {
            return true;
        }
        return this._selectedNodes[0] instanceof TableNode;
    }

    public void run() {
        try {
            String query = null;
            if (this._selectedNodes[0] instanceof ColumnNode) {
                query = this.createColumnSelect();
            }
            if (this._selectedNodes[0] instanceof TableNode) {
                query = this.createTableSelect();
            }
            if (query == null) {
                return;
            }
            SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(this._selectedNodes[0].getSession());
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
            editorPart.setText(query);
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Could generate sql.", e);
        }
    }
}

