/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.actions;

import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.dialogs.FilterStructureDialog;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public class FilterStructureAction
extends Action {
    private DatabaseStructureView _view;

    public FilterStructureAction(DatabaseStructureView view) {
        this._view = view;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageUtil.getDescriptor("Images.FilterIcon");
    }

    public void run() {
        try {
            FilterStructureDialog dialog = new FilterStructureDialog(this._view);
            SQLAlias alias = (SQLAlias)this._view.getActiveDatabase().getSession().getAlias();
            if (alias.getSchemaFilterExpression() != null && alias.getSchemaFilterExpression().length() != 0) {
                dialog.setSchemaFilter(alias.getSchemaFilterExpression().split(","));
            }
            if (alias.getFolderFilterExpression() != null && alias.getFolderFilterExpression().length() != 0) {
                dialog.setFolderFilter(alias.getFolderFilterExpression().split(","));
            }
            if (alias.getNameFilterExpression() != null && alias.getNameFilterExpression().length() != 0) {
                dialog.setNameFilter(alias.getNameFilterExpression());
            }
            if (dialog.open() != 0) {
                return;
            }
            String[] schemaFilter = dialog.getSchemaFilter();
            StringBuffer schemaFilterString = new StringBuffer("");
            String sep = "";
            if (schemaFilter != null) {
                int i = 0;
                while (i < schemaFilter.length) {
                    schemaFilterString.append(sep);
                    schemaFilterString.append(schemaFilter[i]);
                    sep = ",";
                    ++i;
                }
            }
            alias.setSchemaFilterExpression(schemaFilterString.toString());
            String[] folderFilter = dialog.getFolderFilter();
            StringBuffer folderFilterString = new StringBuffer("");
            sep = "";
            if (folderFilter != null) {
                int i = 0;
                while (i < folderFilter.length) {
                    folderFilterString.append(sep);
                    folderFilterString.append(folderFilter[i]);
                    sep = ",";
                    ++i;
                }
            }
            alias.setFolderFilterExpression(folderFilterString.toString());
            alias.setNameFilterExpression(dialog.getNameFilter());
            this._view.refreshSessionTrees(this._view.getActiveDatabase().getSession().toString());
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error creating dialog", e);
        }
    }
}

