/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.actions;

import java.sql.ResultSet;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.actions.AbstractDBTreeContextAction;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class CreateTableScriptAction
extends AbstractDBTreeContextAction {
    private static final ImageDescriptor _image = ImageUtil.getDescriptor("Images.TableIcon");

    public ImageDescriptor getImageDescriptor() {
        return _image;
    }

    public String getText() {
        return Messages.getString("DatabaseStructureView.Actions.CreateTableScript");
    }

    public void run() {
        TableNode tableNode = (TableNode)this._selectedNodes[0];
        ITableInfo info = tableNode.getTableInfo();
        SQLDatabaseMetaData metaData = tableNode.getSession().getMetaData();
        StringBuffer buf = new StringBuffer(4096);
        String sep = System.getProperty("line.separator");
        try {
            ArrayList<String> pks = new ArrayList<String>();
            ResultSet rsPks = metaData.getPrimaryKeys(info);
            while (rsPks.next()) {
                String name = rsPks.getString(4);
                pks.add(name);
            }
            rsPks.close();
            ResultSet resultSet = metaData.getColumns(info);
            String tableName = this._selectedNodes[0].getQualifiedName();
            buf.append("CREATE TABLE ");
            buf.append(tableName);
            buf.append("(");
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String typeName = resultSet.getString(6);
                String columnSize = resultSet.getString(7);
                String decimalDigits = resultSet.getString(9);
                String defaultValue = resultSet.getString(13);
                boolean notNull = "NO".equalsIgnoreCase(resultSet.getString(18));
                String sLower = typeName.toLowerCase();
                buf.append(sep);
                buf.append(String.valueOf(columnName) + " ");
                buf.append(typeName);
                boolean bNumeric = false;
                if (sLower.equals("numeric") || sLower.equals("number") || sLower.equals("decimal")) {
                    bNumeric = true;
                }
                if (sLower.indexOf("char") != -1 || sLower.indexOf("int") != -1) {
                    buf.append("(");
                    buf.append(columnSize);
                    buf.append(")");
                } else if (bNumeric) {
                    buf.append("(");
                    buf.append(columnSize);
                    String tmp = decimalDigits;
                    if (tmp != null && !"".equals(tmp) && !"0".equals(tmp)) {
                        buf.append(",");
                        buf.append(tmp);
                    }
                    buf.append(")");
                }
                if (pks.size() == 1 && pks.get(0).equals(columnName)) {
                    buf.append(" PRIMARY KEY");
                }
                if (defaultValue != null && !defaultValue.equals("")) {
                    buf.append(" default ");
                    boolean isSystemValue = bNumeric;
                    if (defaultValue.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                        isSystemValue = true;
                    }
                    if (!isSystemValue) {
                        buf.append("'");
                    }
                    buf.append(defaultValue);
                    if (!isSystemValue) {
                        buf.append("'");
                    }
                }
                if (notNull) {
                    buf.append(" not null");
                }
                buf.append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            resultSet.close();
            buf.append(")" + sep);
            SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(this._selectedNodes[0].getSession());
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
            editorPart.setText(buf.toString());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error creating export script", e);
        }
    }

    public boolean isAvailable() {
        return this._selectedNodes.length != 0;
    }
}

