/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbdetail.tab;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dbdetail.tab.AbstractDataSetTab;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;

public class TableInfoTab
extends AbstractDataSetTab {
    public String getLabelText() {
        return Messages.getString("DatabaseDetailView.Tab.Info");
    }

    public DataSet getDataSet() throws Exception {
        INode node = this.getNode();
        if (node == null) {
            return null;
        }
        if (node instanceof TableNode) {
            TableNode tableNode = (TableNode)node;
            ITableInfo tableInfo = tableNode.getTableInfo();
            String[] header = new String[]{Messages.getString("DatabaseDetailView.Tab.Info.Property"), Messages.getString("DatabaseDetailView.Tab.Info.Value")};
            String[][] data = new String[6][2];
            data[0][0] = Messages.getString("DatabaseDetailView.Tab.Info.Name");
            data[0][1] = tableInfo.getSimpleName();
            data[1][0] = Messages.getString("DatabaseDetailView.Tab.Info.QualifiedName");
            data[1][1] = tableInfo.getQualifiedName();
            data[2][0] = Messages.getString("DatabaseDetailView.Tab.Info.Catalog");
            data[2][1] = tableInfo.getCatalogName();
            data[3][0] = Messages.getString("DatabaseDetailView.Tab.Info.Schema");
            data[3][1] = tableInfo.getSchemaName();
            data[4][0] = Messages.getString("DatabaseDetailView.Tab.Info.Type");
            data[4][1] = tableInfo.getType();
            data[5][0] = Messages.getString("DatabaseDetailView.Tab.Info.Remarks");
            data[5][1] = tableInfo.getRemarks();
            int[] types = new int[]{0, 0};
            DataSet dataSet = new DataSet(header, data, types);
            return dataSet;
        }
        return null;
    }

    public String getStatusMessage() {
        return String.valueOf(Messages.getString("DatabaseDetailView.Tab.Info.status")) + " " + this.getNode().getQualifiedName();
    }
}

