/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbdetail.tab;

import java.sql.ResultSet;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dbdetail.tab.AbstractDataSetTab;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;

public class PreviewTab
extends AbstractDataSetTab {
    public String getLabelText() {
        return Messages.getString("DatabaseDetailView.Tab.Preview");
    }

    public DataSet getDataSet() throws Exception {
        INode node = this.getNode();
        if (node == null) {
            return null;
        }
        if (node instanceof TableNode) {
            TableNode tableNode = (TableNode)node;
            int maxResults = SQLExplorerPlugin.getDefault().getPluginPreferences().getInt("SQLEditor.PreRowCount");
            if (maxResults == 0) {
                maxResults = 50;
            }
            Statement statement = tableNode.getSession().getInteractiveConnection().createStatement();
            statement.setMaxRows(maxResults);
            statement.execute("select * from " + tableNode.getQualifiedName());
            ResultSet resultSet = statement.getResultSet();
            DataSet dataSet = new DataSet(null, resultSet, null);
            statement.close();
            resultSet.close();
            return dataSet;
        }
        return null;
    }

    public String getStatusMessage() {
        return String.valueOf(Messages.getString("DatabaseDetailView.Tab.Preview.status")) + " " + this.getNode().getQualifiedName();
    }
}

