/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbdetail.tab;

import java.sql.DatabaseMetaData;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dbdetail.tab.AbstractDataSetTab;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;

public class ConnectionInfoTab
extends AbstractDataSetTab {
    public String getLabelText() {
        return Messages.getString("DatabaseDetailView.Tab.ConnectionInfo");
    }

    public String getStatusMessage() {
        return String.valueOf(Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.status")) + " " + this.getNode().getSession().toString();
    }

    public DataSet getDataSet() throws Exception {
        INode node = this.getNode();
        if (node == null) {
            return null;
        }
        SQLDatabaseMetaData sqlMetaData = node.getSession().getMetaData();
        DatabaseMetaData jdbcMetaData = sqlMetaData.getJDBCMetaData();
        String[] header = new String[]{Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.Property"), Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.Value")};
        String[][] data = new String[124][2];
        data[0][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.DatabaseProductName");
        try {
            data[0][1] = sqlMetaData.getDatabaseProductName();
        }
        catch (Throwable throwable) {}
        data[1][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.DriverMajor");
        try {
            data[1][1] = "" + jdbcMetaData.getDriverMajorVersion();
        }
        catch (Throwable throwable) {}
        data[2][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.DriverMinor");
        try {
            data[2][1] = "" + jdbcMetaData.getDriverMinorVersion();
        }
        catch (Throwable throwable) {}
        data[3][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.DriverName");
        try {
            data[3][1] = sqlMetaData.getDriverName();
        }
        catch (Throwable throwable) {}
        data[4][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.DriverVersion");
        try {
            data[4][1] = jdbcMetaData.getDriverVersion();
        }
        catch (Throwable throwable) {}
        data[5][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.UserName");
        try {
            data[5][1] = sqlMetaData.getUserName();
        }
        catch (Throwable throwable) {}
        data[6][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.URL");
        try {
            data[6][1] = jdbcMetaData.getURL();
        }
        catch (Throwable throwable) {}
        data[7][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.AutocommitMode");
        try {
            data[7][1] = "" + jdbcMetaData.getConnection().getAutoCommit();
        }
        catch (Throwable throwable) {}
        data[8][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.CommitOnClose");
        try {
            data[8][1] = "" + node.getSession().getInteractiveConnection().getCommitOnClose();
        }
        catch (Throwable throwable) {}
        data[9][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.ProceduresCallable");
        try {
            data[9][1] = "" + jdbcMetaData.allProceduresAreCallable();
        }
        catch (Throwable throwable) {}
        data[10][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.TablesSelectable");
        try {
            data[10][1] = "" + jdbcMetaData.allTablesAreSelectable();
        }
        catch (Throwable throwable) {}
        data[11][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.NullsSortedHigh");
        try {
            data[11][1] = "" + jdbcMetaData.nullsAreSortedHigh();
        }
        catch (Throwable throwable) {}
        data[12][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.NullsSortedLow");
        try {
            data[12][1] = "" + jdbcMetaData.nullsAreSortedLow();
        }
        catch (Throwable throwable) {}
        data[13][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.NullsSortedStart");
        try {
            data[13][1] = "" + jdbcMetaData.nullsAreSortedAtStart();
        }
        catch (Throwable throwable) {}
        data[14][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.NullsSortedEnd");
        try {
            data[14][1] = "" + jdbcMetaData.nullsAreSortedAtEnd();
        }
        catch (Throwable throwable) {}
        data[15][0] = "Result Set Holdability";
        try {
            data[15][1] = "" + jdbcMetaData.getResultSetHoldability();
        }
        catch (Throwable throwable) {}
        data[16][0] = "Uses Local Files";
        try {
            data[16][1] = "" + jdbcMetaData.usesLocalFiles();
        }
        catch (Throwable throwable) {}
        data[17][0] = "Uses Local File per Table";
        try {
            data[17][1] = "" + jdbcMetaData.usesLocalFilePerTable();
        }
        catch (Throwable throwable) {}
        data[18][0] = "Supports Mixed Case Identifiers";
        try {
            data[18][1] = "" + jdbcMetaData.supportsMixedCaseIdentifiers();
        }
        catch (Throwable throwable) {}
        data[19][0] = "Stores Upper Case Identifiers";
        try {
            data[19][1] = "" + jdbcMetaData.storesUpperCaseIdentifiers();
        }
        catch (Throwable throwable) {}
        data[20][0] = "Stores Lower Case Identifiers";
        try {
            data[20][1] = "" + jdbcMetaData.storesLowerCaseIdentifiers();
        }
        catch (Throwable throwable) {}
        data[21][0] = "Stores Mixed Case Identifiers";
        try {
            data[21][1] = "" + jdbcMetaData.storesMixedCaseIdentifiers();
        }
        catch (Throwable throwable) {}
        data[22][0] = "Supports Mixed Case Quoted Identifiers";
        try {
            data[22][1] = "" + jdbcMetaData.supportsMixedCaseQuotedIdentifiers();
        }
        catch (Throwable throwable) {}
        data[23][0] = "Stores Upper Case Quoted Identifiers";
        try {
            data[23][1] = "" + jdbcMetaData.storesUpperCaseQuotedIdentifiers();
        }
        catch (Throwable throwable) {}
        data[24][0] = "Stores Lower Case Quoted Identifiers";
        try {
            data[24][1] = "" + jdbcMetaData.storesLowerCaseQuotedIdentifiers();
        }
        catch (Throwable throwable) {}
        data[25][0] = "Stores Mixed Case Quoted Identifiers";
        try {
            data[25][1] = "" + jdbcMetaData.storesMixedCaseQuotedIdentifiers();
        }
        catch (Throwable throwable) {}
        data[26][0] = "Identifier Quote";
        try {
            data[26][1] = jdbcMetaData.getIdentifierQuoteString();
        }
        catch (Throwable throwable) {}
        data[27][0] = "Search String Escape";
        try {
            data[27][1] = jdbcMetaData.getSearchStringEscape();
        }
        catch (Throwable throwable) {}
        data[28][0] = "Extra Name Characters";
        try {
            data[28][1] = jdbcMetaData.getExtraNameCharacters();
        }
        catch (Throwable throwable) {}
        data[29][0] = "Supports Alter Table With Add Column";
        try {
            data[29][1] = "" + jdbcMetaData.supportsAlterTableWithAddColumn();
        }
        catch (Throwable throwable) {}
        data[30][0] = "Supports Alter Table With Drop Column";
        try {
            data[30][1] = "" + jdbcMetaData.supportsAlterTableWithDropColumn();
        }
        catch (Throwable throwable) {}
        data[31][0] = "Supports Column Aliasing";
        try {
            data[31][1] = "" + jdbcMetaData.supportsColumnAliasing();
        }
        catch (Throwable throwable) {}
        data[32][0] = "Null Plus Non Null Is Null";
        try {
            data[32][1] = "" + jdbcMetaData.nullPlusNonNullIsNull();
        }
        catch (Throwable throwable) {}
        data[33][0] = "Supports Convert";
        try {
            data[33][1] = "" + jdbcMetaData.supportsConvert();
        }
        catch (Throwable throwable) {}
        data[34][0] = "Supports Table Correlation Names";
        try {
            data[34][1] = "" + jdbcMetaData.supportsTableCorrelationNames();
        }
        catch (Throwable throwable) {}
        data[35][0] = "Supports Different Table Correlation Names";
        try {
            data[35][1] = "" + jdbcMetaData.supportsDifferentTableCorrelationNames();
        }
        catch (Throwable throwable) {}
        data[36][0] = "Supports Expressions in Order By";
        try {
            data[36][1] = "" + jdbcMetaData.supportsExpressionsInOrderBy();
        }
        catch (Throwable throwable) {}
        data[37][0] = "Supports Order By Unrelated";
        try {
            data[37][1] = "" + jdbcMetaData.supportsOrderByUnrelated();
        }
        catch (Throwable throwable) {}
        data[38][0] = "Supports Group By";
        try {
            data[38][1] = "" + jdbcMetaData.supportsGroupBy();
        }
        catch (Throwable throwable) {}
        data[39][0] = "Supports Group By Unrelated";
        try {
            data[39][1] = "" + jdbcMetaData.supportsGroupByUnrelated();
        }
        catch (Throwable throwable) {}
        data[40][0] = "Supports Group By Beyond Select";
        try {
            data[40][1] = "" + jdbcMetaData.supportsGroupByBeyondSelect();
        }
        catch (Throwable throwable) {}
        data[41][0] = "Supports Like Escape Clause";
        try {
            data[41][1] = "" + jdbcMetaData.supportsLikeEscapeClause();
        }
        catch (Throwable throwable) {}
        data[42][0] = "Supports Multiple Result Sets";
        try {
            data[42][1] = "" + jdbcMetaData.supportsMultipleResultSets();
        }
        catch (Throwable throwable) {}
        data[43][0] = "Supports Multiple Open Results ";
        try {
            data[43][1] = "" + jdbcMetaData.supportsMultipleOpenResults();
        }
        catch (Throwable throwable) {}
        data[44][0] = "Supports Multiple Transactions";
        try {
            data[44][1] = "" + jdbcMetaData.supportsMultipleTransactions();
        }
        catch (Throwable throwable) {}
        data[45][0] = "Supports Non Nullable Columns";
        try {
            data[45][1] = "" + jdbcMetaData.supportsNonNullableColumns();
        }
        catch (Throwable throwable) {}
        data[46][0] = "Supports Minimum SQL Grammar";
        try {
            data[46][1] = "" + jdbcMetaData.supportsMinimumSQLGrammar();
        }
        catch (Throwable throwable) {}
        data[47][0] = "Supports Core SQL Grammar";
        try {
            data[47][1] = "" + jdbcMetaData.supportsCoreSQLGrammar();
        }
        catch (Throwable throwable) {}
        data[48][0] = "Supports Extended SQL Grammar";
        try {
            data[48][1] = "" + jdbcMetaData.supportsExtendedSQLGrammar();
        }
        catch (Throwable throwable) {}
        data[49][0] = "Supports ANSI92 Entry Level SQL";
        try {
            data[49][1] = "" + jdbcMetaData.supportsANSI92EntryLevelSQL();
        }
        catch (Throwable throwable) {}
        data[50][0] = "Supports ANSI92 Intermediate SQL";
        try {
            data[50][1] = "" + jdbcMetaData.supportsANSI92IntermediateSQL();
        }
        catch (Throwable throwable) {}
        data[51][0] = "Supports ANSI92 Full SQL";
        try {
            data[51][1] = "" + jdbcMetaData.supportsANSI92FullSQL();
        }
        catch (Throwable throwable) {}
        data[52][0] = "Supports Integrity Enhancement Facility";
        try {
            data[52][1] = "" + jdbcMetaData.supportsIntegrityEnhancementFacility();
        }
        catch (Throwable throwable) {}
        data[53][0] = "Supports Outer Joins";
        try {
            data[53][1] = "" + jdbcMetaData.supportsOuterJoins();
        }
        catch (Throwable throwable) {}
        data[54][0] = "Supports Full Outer Joins";
        try {
            data[54][1] = "" + jdbcMetaData.supportsFullOuterJoins();
        }
        catch (Throwable throwable) {}
        data[55][0] = "Supports Limited Outer Joins";
        try {
            data[55][1] = "" + jdbcMetaData.supportsLimitedOuterJoins();
        }
        catch (Throwable throwable) {}
        data[56][0] = "Schema Term";
        try {
            data[56][1] = jdbcMetaData.getSchemaTerm();
        }
        catch (Throwable throwable) {}
        data[57][0] = "Procedure Term";
        try {
            data[57][1] = jdbcMetaData.getProcedureTerm();
        }
        catch (Throwable throwable) {}
        data[58][0] = "Catalog Term";
        try {
            data[58][1] = jdbcMetaData.getCatalogTerm();
        }
        catch (Throwable throwable) {}
        data[59][0] = "Is Catalog at Start";
        try {
            data[59][1] = "" + jdbcMetaData.isCatalogAtStart();
        }
        catch (Throwable throwable) {}
        data[60][0] = "Catalog Separator";
        try {
            data[60][1] = jdbcMetaData.getCatalogSeparator();
        }
        catch (Throwable throwable) {}
        data[61][0] = "Supports Schemas In Data Manipulation";
        try {
            data[61][1] = "" + jdbcMetaData.supportsSchemasInDataManipulation();
        }
        catch (Throwable throwable) {}
        data[62][0] = "Supports Schemas In Procedure Calls";
        try {
            data[62][1] = "" + jdbcMetaData.supportsSchemasInProcedureCalls();
        }
        catch (Throwable throwable) {}
        data[63][0] = "Supports Schemas In Table Definitions";
        try {
            data[63][1] = "" + jdbcMetaData.supportsSchemasInTableDefinitions();
        }
        catch (Throwable throwable) {}
        data[64][0] = "Supports Schemas In Index Definitions";
        try {
            data[64][1] = "" + jdbcMetaData.supportsSchemasInIndexDefinitions();
        }
        catch (Throwable throwable) {}
        data[65][0] = "Supports Schemas In Privilege Definitions";
        try {
            data[65][1] = "" + jdbcMetaData.supportsSchemasInPrivilegeDefinitions();
        }
        catch (Throwable throwable) {}
        data[66][0] = "Supports Catalogs In Data Manipulation";
        try {
            data[66][1] = "" + jdbcMetaData.supportsCatalogsInDataManipulation();
        }
        catch (Throwable throwable) {}
        data[67][0] = "Supports Catalogs In Procedure Calls";
        try {
            data[67][1] = "" + jdbcMetaData.supportsCatalogsInProcedureCalls();
        }
        catch (Throwable throwable) {}
        data[68][0] = "Supports Catalogs In Table Definitions";
        try {
            data[68][1] = "" + jdbcMetaData.supportsCatalogsInTableDefinitions();
        }
        catch (Throwable throwable) {}
        data[69][0] = "Supports Catalogs In Index Definitions";
        try {
            data[69][1] = "" + jdbcMetaData.supportsCatalogsInIndexDefinitions();
        }
        catch (Throwable throwable) {}
        data[70][0] = "Supports Catalogs In Privilege Definitions";
        try {
            data[70][1] = "" + jdbcMetaData.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (Throwable throwable) {}
        data[71][0] = "Supports Positioned Delete";
        try {
            data[71][1] = "" + jdbcMetaData.supportsPositionedDelete();
        }
        catch (Throwable throwable) {}
        data[72][0] = "Supports Positioned Update";
        try {
            data[72][1] = "" + jdbcMetaData.supportsPositionedUpdate();
        }
        catch (Throwable throwable) {}
        data[73][0] = "Supports Stored Procedures";
        try {
            data[73][1] = "" + jdbcMetaData.supportsStoredProcedures();
        }
        catch (Throwable throwable) {}
        data[74][0] = "Supports Subqueries In Comparisons";
        try {
            data[74][1] = "" + jdbcMetaData.supportsSubqueriesInComparisons();
        }
        catch (Throwable throwable) {}
        data[75][0] = "Supports Subqueries In Exists";
        try {
            data[75][1] = "" + jdbcMetaData.supportsSubqueriesInExists();
        }
        catch (Throwable throwable) {}
        data[76][0] = "Supports Subqueries in IN Statements";
        try {
            data[76][1] = "" + jdbcMetaData.supportsSubqueriesInIns();
        }
        catch (Throwable throwable) {}
        data[77][0] = "Supports Subqueries in Quantified Expressions";
        try {
            data[77][1] = "" + jdbcMetaData.supportsSubqueriesInQuantifieds();
        }
        catch (Throwable throwable) {}
        data[78][0] = "Supports Correlated Subqueries";
        try {
            data[78][1] = "" + jdbcMetaData.supportsCorrelatedSubqueries();
        }
        catch (Throwable throwable) {}
        data[79][0] = "Supports Union";
        try {
            data[79][1] = "" + jdbcMetaData.supportsUnion();
        }
        catch (Throwable throwable) {}
        data[80][0] = "Supports Union All";
        try {
            data[80][1] = "" + jdbcMetaData.supportsUnionAll();
        }
        catch (Throwable throwable) {}
        data[81][0] = "Supports Open Cursors Across Commit";
        try {
            data[81][1] = "" + jdbcMetaData.supportsOpenCursorsAcrossCommit();
        }
        catch (Throwable throwable) {}
        data[82][0] = "Supports Open Cursors Across Rollback";
        try {
            data[82][1] = "" + jdbcMetaData.supportsOpenCursorsAcrossRollback();
        }
        catch (Throwable throwable) {}
        data[83][0] = "Supports Open Statements Across Commit";
        try {
            data[83][1] = "" + jdbcMetaData.supportsOpenStatementsAcrossCommit();
        }
        catch (Throwable throwable) {}
        data[84][0] = "Supports Open Statements Across Rollback";
        try {
            data[84][1] = "" + jdbcMetaData.supportsOpenStatementsAcrossRollback();
        }
        catch (Throwable throwable) {}
        data[85][0] = "Max Binary Literal Length";
        try {
            data[85][1] = "" + jdbcMetaData.getMaxBinaryLiteralLength();
        }
        catch (Throwable throwable) {}
        data[86][0] = "Max Char Literal Length";
        try {
            data[86][1] = "" + jdbcMetaData.getMaxCharLiteralLength();
        }
        catch (Throwable throwable) {}
        data[87][0] = "Max Column Name Length";
        try {
            data[87][1] = "" + jdbcMetaData.getMaxColumnNameLength();
        }
        catch (Throwable throwable) {}
        data[88][0] = "Max Columns In Group By";
        try {
            data[88][1] = "" + jdbcMetaData.getMaxColumnsInGroupBy();
        }
        catch (Throwable throwable) {}
        data[89][0] = "Max Columns In Index";
        try {
            data[89][1] = "" + jdbcMetaData.getMaxColumnsInIndex();
        }
        catch (Throwable throwable) {}
        data[90][0] = "Max Columns In Order By";
        try {
            data[90][1] = "" + jdbcMetaData.getMaxColumnsInOrderBy();
        }
        catch (Throwable throwable) {}
        data[91][0] = "Max Columns In Select";
        try {
            data[91][1] = "" + jdbcMetaData.getMaxColumnsInSelect();
        }
        catch (Throwable throwable) {}
        data[92][0] = "Max Columns In Table";
        try {
            data[92][1] = "" + jdbcMetaData.getMaxColumnsInTable();
        }
        catch (Throwable throwable) {}
        data[93][0] = "Max Connections";
        try {
            data[93][1] = "" + jdbcMetaData.getMaxConnections();
        }
        catch (Throwable throwable) {}
        data[94][0] = "Max Cursor Name Length";
        try {
            data[94][1] = "" + jdbcMetaData.getMaxCursorNameLength();
        }
        catch (Throwable throwable) {}
        data[95][0] = "Max Index Length";
        try {
            data[95][1] = "" + jdbcMetaData.getMaxIndexLength();
        }
        catch (Throwable throwable) {}
        data[96][0] = "Max Schema Name Length";
        try {
            data[96][1] = "" + jdbcMetaData.getMaxSchemaNameLength();
        }
        catch (Throwable throwable) {}
        data[97][0] = "Max Procedure Name Length";
        try {
            data[97][1] = "" + jdbcMetaData.getMaxProcedureNameLength();
        }
        catch (Throwable throwable) {}
        data[98][0] = "Max Catalog Name Length";
        try {
            data[98][1] = "" + jdbcMetaData.getMaxCatalogNameLength();
        }
        catch (Throwable throwable) {}
        data[99][0] = "Max Row Size";
        try {
            data[99][1] = "" + jdbcMetaData.getMaxRowSize();
        }
        catch (Throwable throwable) {}
        data[100][0] = "Max Row Size Include Blobs";
        try {
            data[100][1] = "" + jdbcMetaData.doesMaxRowSizeIncludeBlobs();
        }
        catch (Throwable throwable) {}
        data[101][0] = "Max Statement Length";
        try {
            data[101][1] = "" + jdbcMetaData.getMaxStatementLength();
        }
        catch (Throwable throwable) {}
        data[102][0] = "Max Statements";
        try {
            data[102][1] = "" + jdbcMetaData.getMaxStatements();
        }
        catch (Throwable throwable) {}
        data[103][0] = "Max Table Name Length";
        try {
            data[103][1] = "" + jdbcMetaData.getMaxTableNameLength();
        }
        catch (Throwable throwable) {}
        data[104][0] = "Max Tables In Select";
        try {
            data[104][1] = "" + jdbcMetaData.getMaxTablesInSelect();
        }
        catch (Throwable throwable) {}
        data[105][0] = "Max User Name Length";
        try {
            data[105][1] = "" + jdbcMetaData.getMaxUserNameLength();
        }
        catch (Throwable throwable) {}
        data[106][0] = "Default Transaction Isolation";
        try {
            int isol = jdbcMetaData.getDefaultTransactionIsolation();
            String is = null;
            switch (isol) {
                case 0: {
                    is = "TRANSACTION_NONE";
                    break;
                }
                case 2: {
                    is = "TRANSACTION_READ_COMMITTED";
                    break;
                }
                case 1: {
                    is = "TRANSACTION_READ_UNCOMMITTED";
                    break;
                }
                case 4: {
                    is = "TRANSACTION_REPEATABLE_READ";
                    break;
                }
                case 8: {
                    is = "TRANSACTION_SERIALIZABLE";
                    break;
                }
                default: {
                    is = "";
                }
            }
            data[106][1] = is;
        }
        catch (Throwable throwable) {}
        data[107][0] = "Supports Transactions";
        try {
            data[107][1] = "" + jdbcMetaData.supportsTransactions();
        }
        catch (Throwable throwable) {}
        data[108][0] = "Supports Data Definition and Data Manipulation Transactions";
        try {
            data[108][1] = "" + jdbcMetaData.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (Throwable throwable) {}
        data[109][0] = "Supports Data Manipulation Transactions Only";
        try {
            data[109][1] = "" + jdbcMetaData.supportsDataManipulationTransactionsOnly();
        }
        catch (Throwable throwable) {}
        data[110][0] = "Data Definition Causes Transaction Commit";
        try {
            data[110][1] = "" + jdbcMetaData.dataDefinitionCausesTransactionCommit();
        }
        catch (Throwable throwable) {}
        data[111][0] = "Data Definition Ignored in Transactions";
        try {
            data[111][1] = "" + jdbcMetaData.dataDefinitionIgnoredInTransactions();
        }
        catch (Throwable throwable) {}
        data[112][0] = "Supports Batch Updates";
        try {
            data[112][1] = "" + jdbcMetaData.supportsBatchUpdates();
        }
        catch (Throwable throwable) {}
        data[113][0] = "Supports Savepoints";
        try {
            data[113][1] = "" + jdbcMetaData.supportsSavepoints();
        }
        catch (Throwable throwable) {}
        data[114][0] = "Supports Named Parameters";
        try {
            data[114][1] = "" + jdbcMetaData.supportsNamedParameters();
        }
        catch (Throwable throwable) {}
        data[115][0] = "Supports Get Generated Keys";
        try {
            data[115][1] = "" + jdbcMetaData.supportsGetGeneratedKeys();
        }
        catch (Throwable throwable) {}
        data[116][0] = "Database Major Version";
        try {
            data[116][1] = "" + jdbcMetaData.getDatabaseMajorVersion();
        }
        catch (Throwable throwable) {}
        data[117][0] = "Database Minor Version";
        try {
            data[117][1] = "" + jdbcMetaData.getDatabaseMinorVersion();
        }
        catch (Throwable throwable) {}
        data[118][0] = "JDBC Minor Version";
        try {
            data[118][1] = "" + jdbcMetaData.getJDBCMinorVersion();
        }
        catch (Throwable throwable) {}
        data[119][0] = "JDBC Major Version";
        try {
            data[119][1] = "" + jdbcMetaData.getJDBCMajorVersion();
        }
        catch (Throwable throwable) {}
        data[120][0] = "SQL State Type";
        try {
            data[120][1] = "" + jdbcMetaData.getSQLStateType();
        }
        catch (Throwable throwable) {}
        data[121][0] = "Locators Update Copy";
        try {
            data[121][1] = "" + jdbcMetaData.locatorsUpdateCopy();
        }
        catch (Throwable throwable) {}
        data[122][0] = "Supports Statement Pooling";
        try {
            data[122][1] = "" + jdbcMetaData.supportsStatementPooling();
        }
        catch (Throwable throwable) {}
        data[123][0] = Messages.getString("DatabaseDetailView.Tab.ConnectionInfo.ReadOnly");
        try {
            data[123][1] = "" + jdbcMetaData.isReadOnly();
        }
        catch (Throwable throwable) {}
        int[] types = new int[]{0, 0};
        DataSet dataSet = new DataSet(header, data, types);
        return dataSet;
    }
}

