/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dataset.actions.AbstractDataSetTableContextAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;

public class CopyTableAction
extends AbstractDataSetTableContextAction {
    private static final ImageDescriptor _image = ImageUtil.getDescriptor("Images.CopyIcon");

    public String getText() {
        return Messages.getString("DataSetTable.Actions.CopyToClipboard");
    }

    public ImageDescriptor getImageDescriptor() {
        return _image;
    }

    public void run() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    int i;
                    Clipboard clipBoard = new Clipboard(Display.getCurrent());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    StringBuffer buffer = new StringBuffer("");
                    String lineSeparator = System.getProperty("line.separator");
                    String columnSeparator = SQLExplorerPlugin.getDefault().getPreferenceStore().getString("SQLEditor.ClipExportSeparator");
                    boolean includeColumnNames = SQLExplorerPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditor.ClipExportColumns");
                    TableItem[] items = CopyTableAction.this._table.getItems();
                    DataSet dataSet = (DataSet)CopyTableAction.this._table.getData();
                    if (items == null || dataSet == null) {
                        return;
                    }
                    if (includeColumnNames) {
                        String[] columnNames = dataSet.getColumnLabels();
                        i = 0;
                        while (i < columnNames.length) {
                            buffer.append(columnNames[i]);
                            buffer.append(columnSeparator);
                            ++i;
                        }
                        buffer.append(lineSeparator);
                    }
                    int columnCount = CopyTableAction.this._table.getColumnCount();
                    i = 0;
                    while (i < items.length) {
                        int j = 0;
                        while (j < columnCount) {
                            buffer.append(items[i].getText(j));
                            buffer.append(columnSeparator);
                            ++j;
                        }
                        buffer.append(lineSeparator);
                        ++i;
                    }
                    clipBoard.setContents(new Object[]{buffer.toString()}, new Transfer[]{textTransfer});
                }
                catch (Exception e) {
                    SQLExplorerPlugin.error("Error exporting to clipboard ", e);
                }
            }
        });
    }
}

