/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dataset.DataSetRow;

public class DataSetTableSorter
implements Comparator {
    protected int[] _priorities;
    protected int[] _directions;
    protected int[] _columnTypes;

    public DataSetTableSorter(DataSet dataSet) {
        this._columnTypes = dataSet.getColumnTypes();
        this._priorities = new int[this._columnTypes.length];
        this._directions = new int[this._columnTypes.length];
        int i = 0;
        while (i < this._columnTypes.length) {
            this._directions[i] = 0;
            this._priorities[i] = i;
            ++i;
        }
    }

    public void setTopPriority(int priority, int direction) {
        if (priority < 0 || priority >= this._priorities.length) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this._priorities.length) {
            if (this._priorities[i] == priority) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        i = index;
        while (i > 0) {
            this._priorities[i] = this._priorities[i - 1];
            --i;
        }
        this._priorities[0] = priority;
        this._directions[priority] = direction;
    }

    public int compare(Object e1, Object e2) {
        return this.compareColumnValue((DataSetRow)e1, (DataSetRow)e2, 0);
    }

    private int compareColumnValue(DataSetRow m1, DataSetRow m2, int depth) {
        if (depth >= this._priorities.length) {
            return 0;
        }
        int columnNumber = this._priorities[depth];
        int direction = this._directions[columnNumber];
        int result = 0;
        Object o1 = m1.getObjectValue(columnNumber);
        Object o2 = m2.getObjectValue(columnNumber);
        if (o1 == null || o2 == null) {
            result = o1 == null && o2 != null ? 1 : (o1 != null && o2 == null ? -1 : 0);
            if (result == 0) {
                return this.compareColumnValue(m1, m2, depth + 1);
            }
            if (direction == 1024) {
                return result * -1;
            }
            return result;
        }
        switch (this._columnTypes[columnNumber]) {
            case 0: {
                result = ((String)o1).compareTo((String)o2);
                break;
            }
            case 1: {
                result = ((Double)o1).compareTo((Double)o2);
                break;
            }
            case 2: 
            case 6: {
                result = ((Long)o1).compareTo((Long)o2);
                break;
            }
            case 3: {
                result = ((Date)o1).compareTo((Date)o2);
                break;
            }
            case 4: {
                result = ((Timestamp)o1).compareTo((Timestamp)o2);
                break;
            }
            case 5: {
                result = ((Time)o1).compareTo((Time)o2);
            }
        }
        if (result == 0) {
            return this.compareColumnValue(m1, m2, depth + 1);
        }
        if (direction == 1024) {
            return result * -1;
        }
        return result;
    }
}

