/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections.actions;

import java.util.Iterator;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.connections.actions.AbstractConnectionTreeAction;
import net.sourceforge.sqlexplorer.plugin.views.ConnectionsView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class CloseConnectionAction
extends AbstractConnectionTreeAction
implements IViewActionDelegate {
    private ImageDescriptor _image = ImageUtil.getDescriptor("Images.CloseConnIcon");
    private ImageDescriptor _disabledImage = ImageUtil.getDescriptor("Images.DisabledCloseConnIcon");

    public void init(IViewPart view) {
        this._treeViewer = ((ConnectionsView)view).getTreeViewer();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.isAvailable());
    }

    public void run() {
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof SessionTreeNode)) continue;
            SessionTreeNode node = (SessionTreeNode)o;
            node.close();
        }
        this._treeViewer.refresh();
    }

    public String getText() {
        return Messages.getString("ConnectionsView.Actions.CloseConnection");
    }

    public String getToolTipText() {
        return Messages.getString("ConnectionsView.Actions.CloseConnectionToolTip");
    }

    public ImageDescriptor getImageDescriptor() {
        return this._image;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return this._disabledImage;
    }

    public boolean isAvailable() {
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof SessionTreeNode)) continue;
            return true;
        }
        return false;
    }
}

