/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections;

import net.sourceforge.sqlexplorer.LoginProgress;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLDriverManager;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class OpenConnectionJob
extends Job {
    private ISQLAlias _alias;
    private boolean _autoCommit;
    private boolean _commitOnClose;
    private ISQLDriver _driver;
    private SQLDriverManager _driverMgr;
    private LoginProgress _login;
    private String _pwd;
    private Shell _shell;
    private String _user;
    private static final String ID = "net.sourceforge.sqlexplorer";

    private OpenConnectionJob() {
        super(null);
    }

    public OpenConnectionJob(SQLDriverManager dm, ISQLDriver dv, ISQLAlias al, String user, String pwd, boolean autoCommit, boolean commitOnClose, Shell shell) {
        super(String.valueOf(Messages.getString("Progress.Connection.Title")) + " " + al.getName());
        this._driverMgr = dm;
        this._driver = dv;
        this._alias = al;
        this._user = user;
        this._pwd = pwd;
        this._autoCommit = autoCommit;
        this._commitOnClose = commitOnClose;
        this._shell = shell;
    }

    private void cleanUp() {
        SQLConnection[] connections = this._login.getConnections();
        int i = 0;
        while (i < connections.length) {
            if (connections[i] != null) {
                try {
                    connections[i].close();
                }
                catch (Exception e) {
                    SQLExplorerPlugin.error("Couldn't close connection.", e);
                }
            }
            ++i;
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this._login = new LoginProgress(this._driverMgr, this._driver, this._alias, this._user, this._pwd);
        try {
            this._login.run(monitor);
        }
        catch (InterruptedException interruptedException) {
            this.cleanUp();
            return new Status(8, ID, 8, Messages.getString("Progress.Connection.Cancelled"), null);
        }
        catch (Exception e) {
            this.cleanUp();
            return new Status(4, ID, 8, Messages.getString("Progress.Connection.Error"), (Throwable)e);
        }
        if (this._login.getError() != null) {
            return new Status(4, ID, 8, this._login.getError(), null);
        }
        SQLConnection[] connections = this._login.getConnections();
        try {
            int i = 0;
            while (i < connections.length) {
                connections[i].setAutoCommit(this._autoCommit);
                if (!this._autoCommit) {
                    connections[i].setCommitOnClose(this._commitOnClose);
                }
                ++i;
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error setting commit properties", e);
            return new Status(4, ID, 8, Messages.getString("Progress.Connection.Error"), (Throwable)e);
        }
        SessionTreeNode session = null;
        try {
            monitor.setTaskName(Messages.getString("RetrievingTableDataProgress.Getting_Database_Structure_Data_1"));
            session = SQLExplorerPlugin.getDefault().stm.createSessionTreeNode(connections, this._alias, monitor, this._pwd);
            monitor.done();
        }
        catch (InterruptedException interruptedException) {
            this.cleanUp();
            return new Status(8, ID, 8, Messages.getString("Progress.Connection.Cancelled"), null);
        }
        catch (Exception e) {
            this.cleanUp();
            return new Status(4, ID, 8, Messages.getString("Progress.Connection.Error"), (Throwable)e);
        }
        final SessionTreeNode newSession = session;
        this._shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    DatabaseStructureView dbView = (DatabaseStructureView)SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView");
                    if (dbView != null) {
                        dbView.addSession(newSession);
                    }
                    SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
                    input.setSessionNode(newSession);
                    IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error updating ui with new session", e);
                }
            }
        });
        return new Status(0, ID, 0, "tested ok ", null);
    }
}

