/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ConnectionTreeLabelProvider
extends LabelProvider {
    private Image _inactiveAliasImage = ImageUtil.getImage("Images.AliasIcon");
    private Image _activeAliasImage = ImageUtil.getImage("Images.ConnectedAliasIcon");
    private Image _sessionImage = ImageUtil.getImage("Images.ConnectionIcon");

    public void dispose() {
        super.dispose();
        ImageUtil.disposeImage("Images.AliasIcon");
        ImageUtil.disposeImage("Images.ConnectedAliasIcon");
        ImageUtil.disposeImage("Images.ConnectionIcon");
    }

    public Image getImage(Object element) {
        if (element instanceof ISQLAlias) {
            ISQLAlias alias = (ISQLAlias)element;
            RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
            Object[] sessions = sessionRoot.getChildren();
            ArrayList<SessionTreeNode> children = new ArrayList<SessionTreeNode>();
            if (sessions != null) {
                int i = 0;
                while (i < sessions.length) {
                    SessionTreeNode session = (SessionTreeNode)sessions[i];
                    if (session.getAlias().getIdentifier().equals((Object)alias.getIdentifier())) {
                        children.add(session);
                    }
                    ++i;
                }
            }
            if (children.size() != 0) {
                return this._activeAliasImage;
            }
            return this._inactiveAliasImage;
        }
        return this._sessionImage;
    }

    public String getText(Object element) {
        if (element instanceof ISQLAlias) {
            ISQLAlias alias = (ISQLAlias)element;
            String label = alias.getName();
            RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
            Object[] sessions = sessionRoot.getChildren();
            ArrayList<SessionTreeNode> children = new ArrayList<SessionTreeNode>();
            if (sessions != null) {
                int i = 0;
                while (i < sessions.length) {
                    SessionTreeNode session = (SessionTreeNode)sessions[i];
                    if (session.getAlias().getIdentifier().equals((Object)alias.getIdentifier())) {
                        children.add(session);
                    }
                    ++i;
                }
            }
            if (children.size() == 0) {
                return label;
            }
            if (children.size() == 1) {
                label = String.valueOf(label) + " (" + children.size() + " " + Messages.getString("ConnectionsView.ConnectedAlias.single.Postfix") + ")";
                return label;
            }
            if (children.size() > 1) {
                label = String.valueOf(label) + " (" + children.size() + " " + Messages.getString("ConnectionsView.ConnectedAlias.multiple.Postfix") + ")";
                return label;
            }
            return label;
        }
        String label = Messages.getString("ConnectionsView.ConnectedAlias.activeSession");
        SessionTreeNode session = (SessionTreeNode)element;
        SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss");
        return String.valueOf(label) + " " + fmt.format(new Date(session.getCreated()));
    }
}

