/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ConnectionTreeContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AliasModel) {
            Object[] children = ((AliasModel)parentElement).getElements();
            return children;
        }
        if (parentElement instanceof ISQLAlias) {
            ISQLAlias alias = (ISQLAlias)parentElement;
            RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
            Object[] sessions = sessionRoot.getChildren();
            ArrayList<SessionTreeNode> children = new ArrayList<SessionTreeNode>();
            if (sessions != null) {
                int i = 0;
                while (i < sessions.length) {
                    SessionTreeNode session = (SessionTreeNode)sessions[i];
                    if (session.getAlias().getIdentifier().equals((Object)alias.getIdentifier())) {
                        children.add(session);
                    }
                    ++i;
                }
            }
            if (children.size() != 0) {
                return children.toArray(new Object[0]);
            }
            return null;
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof AliasModel) {
            return null;
        }
        if (element instanceof ISQLAlias) {
            return SQLExplorerPlugin.getDefault().getAliasModel();
        }
        if (element instanceof SessionTreeNode) {
            SessionTreeNode node = (SessionTreeNode)element;
            return node.getAlias();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] tmp = this.getChildren(element);
        if (tmp != null) {
            return tmp.length != 0;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

