/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLDriverManager;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class LoginProgress
implements IRunnableWithProgress {
    private ISQLAlias _alias;
    private SQLConnection _backgroundConnection;
    private Throwable _backgroundError;
    private String _backgroundErrorMsg;
    private ISQLDriver _driver;
    private SQLDriverManager _driverMgr;
    private SQLConnection _interActiveConnection;
    private Throwable _interactiveError;
    private String _interactiveErrorMsg;
    private String _pwd;
    private String _user;
    private static final Log _logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.LoginProgress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = LogFactory.getLog((Class)clazz);
    }

    public LoginProgress(SQLDriverManager dm, ISQLDriver dv, ISQLAlias al, String user, String pwd) {
        this._driverMgr = dm;
        this._driver = dv;
        this._alias = al;
        this._user = user;
        this._pwd = pwd;
    }

    public SQLConnection[] getConnections() {
        return new SQLConnection[]{this._interActiveConnection, this._backgroundConnection};
    }

    public String getError() {
        if (this._interactiveErrorMsg == null) {
            return this._backgroundErrorMsg;
        }
        return this._interactiveErrorMsg;
    }

    public boolean isOk() {
        return this._interactiveError == null && this._backgroundError == null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.setTaskName(Messages.getString("Logging_to_database..._1"));
        monitor.beginTask(Messages.getString("Logging_to_database..._1"), -1);
        try {
            try {
                long start = System.currentTimeMillis();
                InteractiveConnectionThread iThread = new InteractiveConnectionThread();
                iThread.start();
                BackgroundConnectionThread bgThread = new BackgroundConnectionThread();
                bgThread.start();
                while (true) {
                    if (monitor.isCanceled()) {
                        if (iThread.isAlive()) {
                            iThread.interrupt();
                        }
                        this._interactiveError = null;
                        if (this._interActiveConnection != null) {
                            this._interActiveConnection.close();
                        }
                        this._interActiveConnection = null;
                        if (bgThread.isAlive()) {
                            bgThread.interrupt();
                        }
                        this._backgroundError = null;
                        if (this._backgroundConnection != null) {
                            this._backgroundConnection.close();
                        }
                        this._backgroundConnection = null;
                        break;
                    }
                    if (this._interactiveError != null || this._backgroundError != null) {
                        this._interActiveConnection = null;
                        this._backgroundConnection = null;
                        break;
                    }
                    if (this._interActiveConnection != null && this._backgroundConnection != null && !iThread.isAlive() && !bgThread.isAlive()) {
                        _logger.debug((Object)("# " + (System.currentTimeMillis() - start) + " ms to open both connections."));
                        break;
                    }
                    Thread.sleep(100L);
                }
                if (monitor.isCanceled()) {
                    monitor.done();
                    throw new InterruptedException("Connection cancelled.");
                }
                monitor.done();
            }
            catch (Throwable e) {
                this._interactiveError = e;
                this._interactiveErrorMsg = e.getMessage();
                SQLExplorerPlugin.error("Error logging to database", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    private class BackgroundConnectionThread
    extends Thread {
        private BackgroundConnectionThread() {
        }

        public void run() {
            try {
                long start = System.currentTimeMillis();
                LoginProgress.this._backgroundConnection = LoginProgress.this._driverMgr.getConnection(LoginProgress.this._driver, LoginProgress.this._alias, LoginProgress.this._user, LoginProgress.this._pwd);
                _logger.debug((Object)("# " + (System.currentTimeMillis() - start) + " ms to open background connection."));
            }
            catch (Throwable e) {
                LoginProgress.this._backgroundError = e;
                LoginProgress.this._backgroundErrorMsg = e.getMessage();
                SQLExplorerPlugin.error("Error logging to database", e);
            }
        }
    }

    private class InteractiveConnectionThread
    extends Thread {
        private InteractiveConnectionThread() {
        }

        public void run() {
            try {
                long start = System.currentTimeMillis();
                LoginProgress.this._interActiveConnection = LoginProgress.this._driverMgr.getConnection(LoginProgress.this._driver, LoginProgress.this._alias, LoginProgress.this._user, LoginProgress.this._pwd);
                _logger.debug((Object)("# " + (System.currentTimeMillis() - start) + " ms to open interactive connection."));
            }
            catch (Throwable e) {
                LoginProgress.this._interactiveError = e;
                LoginProgress.this._interactiveErrorMsg = e.getMessage();
                SQLExplorerPlugin.error("Error logging to database", e);
            }
        }
    }
}

