/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.net.MalformedURLException;
import java.util.Comparator;
import net.sourceforge.sqlexplorer.DataCache;
import net.sourceforge.sqlexplorer.util.SortedList;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;

public class DriverModel {
    private SortedList sl;
    private DataCache cache;
    private static ISQLDriverComparator iSQLDriverComparator = new ISQLDriverComparator();

    public DriverModel(DataCache c) {
        this.cache = c;
        this.sl = new SortedList(iSQLDriverComparator);
        this.sl.addAll(c.drivers());
    }

    public int size() {
        return this.sl.size();
    }

    public ISQLDriver getElement(int i) {
        return (ISQLDriver)this.sl.get(i);
    }

    public Object[] getElements() {
        return this.sl.toArray();
    }

    public void removeDriver(ISQLDriver dv) {
        this.cache.removeDriver(dv);
        this.sl.remove(dv);
    }

    public ISQLDriver getDriver(IIdentifier id) {
        return this.cache.getDriver(id);
    }

    public ISQLDriver createDriver(IIdentifier id) {
        return this.cache.createDriver(id);
    }

    public void addDriver(ISQLDriver dv) throws DuplicateObjectException, ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException {
        this.cache.addDriver(dv);
        this.sl.add(dv);
    }

    public void restoreDrivers() {
        this.cache.restoreDefaultDrivers();
        this.sl = new SortedList(iSQLDriverComparator);
        this.sl.addAll(this.cache.drivers());
    }

    private static class ISQLDriverComparator
    implements Comparator {
        private ISQLDriverComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((ISQLDriver)o1).getName().compareToIgnoreCase(((ISQLDriver)o2).getName());
        }
    }
}

