/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.traversal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.traversal.RestPathParser;
import org.neo4j.rest.graphdb.util.ResourceIterableWrapper;
import org.neo4j.rest.graphdb.util.WrappingResourceIterator;

public class RestTraverser
implements Traverser {
    private final Collection<Path> paths;

    public RestTraverser(Collection col, RestAPI restApi) {
        this.paths = this.parseToPaths(col, restApi);
    }

    private Collection<Path> parseToPaths(Collection col, RestAPI restApi) {
        ArrayList<Path> result = new ArrayList<Path>(col.size());
        for (Object path : col) {
            if (!(path instanceof Map)) {
                throw new RuntimeException("Expected Map for Path representation but got: " + (path != null ? path.getClass() : null));
            }
            result.add(RestPathParser.parse((Map)path, restApi));
        }
        return result;
    }

    public ResourceIterable<Node> nodes() {
        return new ResourceIterableWrapper<Node, Path>(this.paths){

            protected Node underlyingObjectToObject(Path path) {
                return path.endNode();
            }
        };
    }

    public ResourceIterable<Relationship> relationships() {
        return new ResourceIterableWrapper<Relationship, Path>(this.paths){

            protected Relationship underlyingObjectToObject(Path path) {
                return path.lastRelationship();
            }
        };
    }

    public ResourceIterator<Path> iterator() {
        return new WrappingResourceIterator<Path>(this.paths.iterator());
    }

    public TraversalMetadata metadata() {
        throw new UnsupportedOperationException();
    }
}

