/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.entity;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIInternal;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.util.ResourceIterableWrapper;

public class RestNode
extends RestEntity
implements Node {
    private Set<String> labels = null;
    private long lastLabelFetchTime = 0L;

    public RestNode(URI uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestNode(String uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestNode(Map<?, ?> data, RestAPI restApi) {
        super(data, restApi);
        if (data.containsKey("metadata")) {
            this.setLabels((Collection)((Map)data.get("metadata")).get("labels"));
        }
    }

    public RestNode(long id, Collection<String> labels, Map<String, Object> restData, RestAPI facade) {
        super(id, restData, facade);
        this.setLabels(labels);
    }

    public RestNode(RestNode node, RestAPI facade) {
        super(node, facade);
        this.setLabels(node.labels);
    }

    public static RestNode fromCypher(long id, Collection<String> labels, Map<String, Object> props, RestAPI facade) {
        Map restData = MapUtil.map((Object[])new Object[]{"data", props, "self", RestNode.nodeUri(facade, id)});
        return new RestNode(id, labels, restData, facade);
    }

    @Override
    protected void doUpdate() {
        this.updateFrom(this.restApi.getNodeById(this.getId(), RestAPIInternal.Load.ForceFromServer), this.restApi);
    }

    @Override
    public void updateFrom(RestEntity entity, RestAPI restApi) {
        super.updateFrom(entity, restApi);
        RestNode node = (RestNode)entity;
        if (node.lastLabelFetchTime > this.lastLabelFetchTime && node.labels != null) {
            this.setLabels(node.labels);
        }
    }

    public Relationship createRelationshipTo(Node toNode, RelationshipType type) {
        return this.restApi.createRelationship(this, toNode, type, null);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.restApi.getRelationshipTypes(this);
    }

    public int getDegree() {
        return this.restApi.getDegree(this, null, Direction.BOTH);
    }

    public int getDegree(RelationshipType type) {
        return this.restApi.getDegree(this, type, Direction.BOTH);
    }

    public int getDegree(Direction direction) {
        return this.restApi.getDegree(this, null, direction);
    }

    public int getDegree(RelationshipType type, Direction direction) {
        return this.restApi.getDegree(this, type, direction);
    }

    public Iterable<Relationship> getRelationships() {
        return this.restApi.getRelationships(this, Direction.BOTH, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.restApi.getRelationships(this, Direction.BOTH, types);
    }

    public Iterable<Relationship> getRelationships(Direction direction) {
        return this.restApi.getRelationships(this, direction, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(RelationshipType type, Direction direction) {
        return this.restApi.getRelationships(this, direction, type);
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction direction) {
        return (Relationship)IteratorUtil.singleOrNull(this.getRelationships(type, direction));
    }

    public boolean hasRelationship() {
        return this.getRelationships().iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.getRelationships(types).iterator().hasNext();
    }

    public boolean hasRelationship(Direction direction) {
        return this.getRelationships(direction).iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType type, Direction direction) {
        return this.getRelationships(type, direction).iterator().hasNext();
    }

    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... rels) {
        throw new UnsupportedOperationException();
    }

    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType type, Direction direction) {
        throw new UnsupportedOperationException();
    }

    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType type, Direction direction, RelationshipType secondType, Direction secondDirection) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> getRelationships(final Direction direction, RelationshipType ... types) {
        return new CombiningIterable((Iterable)new IterableWrapper<Iterable<Relationship>, RelationshipType>(Arrays.asList(types)){

            protected Iterable<Relationship> underlyingObjectToObject(RelationshipType relationshipType) {
                return RestNode.this.getRelationships(relationshipType, direction);
            }
        });
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        for (RelationshipType relationshipType : types) {
            if (!this.hasRelationship(relationshipType, direction)) continue;
            return true;
        }
        return false;
    }

    public void addLabel(Label label) {
        this.restApi.addLabels(this, Collections.singleton(label.name()));
        if (this.labels != null) {
            this.labels.add(label.name());
        } else {
            this.updateLabels();
        }
    }

    public void removeLabel(Label label) {
        this.restApi.removeLabel(this, label.name());
        if (this.labels != null) {
            this.labels.remove(label.name());
        } else {
            this.updateLabels();
        }
    }

    public boolean hasLabel(Label label) {
        this.updateLabels();
        return this.labels.contains(label.name());
    }

    private void updateLabels() {
        if (this.hasToUpdateLabels()) {
            this.doUpdate();
        }
    }

    public void setLabels(Collection<String> labels) {
        this.labels = labels == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(labels);
        this.lastLabelFetchTime = System.currentTimeMillis();
    }

    private boolean hasToUpdateLabels() {
        return this.labels == null || this.restApi.hasToUpdate(this.lastLabelFetchTime);
    }

    public ResourceIterable<Label> getLabels() {
        this.updateLabels();
        return new ResourceIterableWrapper<Label, String>(this.labels){

            protected Label underlyingObjectToObject(String s) {
                return DynamicLabel.label((String)s);
            }
        };
    }

    @Override
    public void addAllLabelsBatch(Collection<String> labels) {
        this.setLabels(labels);
        this.restApi.addLabels(this, labels);
    }
}

